/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.Set;
import mage.cards.decks.Deck;
import mage.constants.TournamentPlayerState;
import mage.game.result.ResultProtos;
import mage.players.Player;
import mage.players.PlayerType;
import mage.util.DeckBuildUtils;
import mage.util.TournamentUtil;
import org.apache.log4j.Logger;

public class TournamentPlayer {
    private static final Logger logger = Logger.getLogger(TournamentPlayer.class);
    protected int points;
    protected PlayerType playerType;
    protected TournamentPlayerState state;
    protected String stateInfo;
    protected String disconnectInfo;
    protected Player player;
    protected Deck deck = null;
    protected String results;
    protected boolean eliminated = false;
    protected boolean quit = false;
    protected boolean doneConstructing;
    protected boolean joined = false;
    protected ResultProtos.TourneyQuitStatus quitStatus = ResultProtos.TourneyQuitStatus.NO_TOURNEY_QUIT;
    protected TournamentPlayer replacedTournamentPlayer;

    public TournamentPlayer(Player player, PlayerType playerType) {
        this.player = player;
        this.playerType = playerType;
        this.state = TournamentPlayerState.JOINED;
        this.stateInfo = "";
        this.disconnectInfo = "";
        this.results = "";
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerType getPlayerType() {
        return this.playerType;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public boolean isEliminated() {
        return this.eliminated;
    }

    public void setEliminated() {
        this.setDisconnectInfo("");
        this.setState(TournamentPlayerState.ELIMINATED);
        this.eliminated = true;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void setJoined() {
        this.joined = true;
    }

    public void setConstructing() {
        this.setState(TournamentPlayerState.CONSTRUCTING);
        this.doneConstructing = false;
    }

    public void submitDeck(Deck deck) {
        this.deck = deck;
        this.doneConstructing = true;
        this.setState(TournamentPlayerState.WAITING);
    }

    public boolean updateDeck(Deck deck, boolean ignoreMainBasicLands) {
        boolean isGood;
        boolean bl = isGood = this.getDeck().getDeckHash(ignoreMainBasicLands) == deck.getDeckHash(ignoreMainBasicLands);
        if (!isGood) {
            logger.error((Object)("Found cheating tourney player " + this.player.getName() + " with changed deck, main " + deck.getCards().size() + ", side " + deck.getSideboard().size()));
            deck.getCards().clear();
            deck.getSideboard().clear();
        }
        this.deck = deck;
        return isGood;
    }

    public Deck generateDeck(int minDeckSize) {
        if (this.deck.getMaindeckCards().size() < minDeckSize) {
            int[] lands = DeckBuildUtils.landCountSuggestion(minDeckSize, this.deck.getMaindeckCards());
            Set<String> landSets = TournamentUtil.getLandSetCodeForDeckSets(this.deck.getExpansionSetCodes());
            this.deck.getCards().addAll(TournamentUtil.getLands("Plains", lands[0], landSets));
            this.deck.getCards().addAll(TournamentUtil.getLands("Island", lands[1], landSets));
            this.deck.getCards().addAll(TournamentUtil.getLands("Swamp", lands[2], landSets));
            this.deck.getCards().addAll(TournamentUtil.getLands("Mountain", lands[3], landSets));
            this.deck.getCards().addAll(TournamentUtil.getLands("Forest", lands[4], landSets));
        }
        this.doneConstructing = true;
        this.setState(TournamentPlayerState.WAITING);
        return this.deck;
    }

    public boolean isDoneConstructing() {
        return this.doneConstructing;
    }

    public void setDeck(Deck deck) {
        this.deck = deck;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public TournamentPlayerState getState() {
        return this.state;
    }

    public void setState(TournamentPlayerState state) {
        this.state = state;
    }

    public String getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(String stateInfo) {
        this.stateInfo = stateInfo;
    }

    public String getDisconnectInfo() {
        return this.disconnectInfo;
    }

    public void setDisconnectInfo(String disconnectInfo) {
        this.disconnectInfo = disconnectInfo;
    }

    public boolean hasQuit() {
        return this.quit;
    }

    public void setQuit(String info, ResultProtos.TourneyQuitStatus status) {
        this.setEliminated();
        this.setState(TournamentPlayerState.CANCELED);
        this.setStateInfo(info);
        this.quit = true;
        this.doneConstructing = true;
        this.quitStatus = status;
    }

    public void cleanUpOnTournamentEnd() {
        this.deck = null;
    }

    public void setStateAtTournamentEnd() {
        if (this.getState() == TournamentPlayerState.DRAFTING || this.getState() == TournamentPlayerState.CONSTRUCTING || this.getState() == TournamentPlayerState.DUELING || this.getState() == TournamentPlayerState.SIDEBOARDING || this.getState() == TournamentPlayerState.WAITING) {
            this.setState(TournamentPlayerState.FINISHED);
        }
    }

    public boolean isInTournament() {
        return this.getState() != TournamentPlayerState.CANCELED && this.getState() != TournamentPlayerState.ELIMINATED && this.getState() != TournamentPlayerState.FINISHED;
    }

    public TournamentPlayer getReplacedTournamentPlayer() {
        return this.replacedTournamentPlayer;
    }

    public void setReplacedTournamentPlayer(TournamentPlayer player) {
        this.replacedTournamentPlayer = player;
    }

    public ResultProtos.TourneyPlayerProto toProto() {
        return ResultProtos.TourneyPlayerProto.newBuilder().setName(this.player.getName()).setPlayerType(this.playerType.toString()).setQuit(this.quitStatus).build();
    }
}

