/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.Map;
import mage.constants.MultiplayerAttackOption;
import mage.game.events.TableEvent;
import mage.game.tournament.MultiplayerRound;
import mage.game.tournament.Round;
import mage.game.tournament.TournamentImpl;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;

public abstract class TournamentSingleElimination
extends TournamentImpl {
    public TournamentSingleElimination(TournamentOptions options) {
        super(options);
    }

    @Override
    protected void runTournament() {
        Object round;
        for (Map.Entry entry : this.players.entrySet()) {
            if (!((TournamentPlayer)entry.getValue()).getPlayer().autoLoseGame()) continue;
            ((TournamentPlayer)entry.getValue()).setEliminated();
            ((TournamentPlayer)entry.getValue()).setResults("Auto Eliminated");
        }
        if (this.options.matchOptions.isSingleGameTourney()) {
            this.options.matchOptions.setAttackOption(MultiplayerAttackOption.MULTIPLE);
            round = new MultiplayerRound(0, this);
            for (TournamentPlayer player : this.getActivePlayers()) {
                ((MultiplayerRound)round).addPlayer(player);
            }
            this.playMultiplayerRound((MultiplayerRound)round);
        } else {
            while (this.getActivePlayers().size() > 1) {
                this.tableEventSource.fireTableEvent(TableEvent.EventType.CHECK_STATE_PLAYERS);
                round = this.createRoundRandom();
                this.playRound((Round)round);
                this.eliminatePlayers((Round)round);
            }
        }
        this.nextStep();
    }

    private void eliminatePlayers(Round round) {
        for (TournamentPairing pair : round.getPairs()) {
            pair.eliminatePlayers();
        }
    }
}

