/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.DrawStep;
import mage.game.turn.Phase;
import mage.game.turn.UntapStep;
import mage.game.turn.UpkeepStep;

public class BeginningPhase
extends Phase {
    private final boolean isExtra;

    public BeginningPhase() {
        this(false);
    }

    public BeginningPhase(boolean isExtra) {
        this.type = TurnPhase.BEGINNING;
        this.event = isExtra ? GameEvent.EventType.BEGINNING_PHASE_EXTRA : GameEvent.EventType.BEGINNING_PHASE;
        this.preEvent = isExtra ? GameEvent.EventType.BEGINNING_PHASE_PRE_EXTRA : GameEvent.EventType.BEGINNING_PHASE_PRE;
        this.postEvent = isExtra ? GameEvent.EventType.BEGINNING_PHASE_PRE_EXTRA : GameEvent.EventType.BEGINNING_PHASE_POST;
        this.steps.add(new UntapStep());
        this.steps.add(new UpkeepStep());
        this.steps.add(new DrawStep());
        this.isExtra = isExtra;
    }

    @Override
    public boolean beginPhase(Game game, UUID activePlayerId) {
        if (!this.isExtra) {
            game.getBattlefield().beginningOfTurn(game);
        }
        return super.beginPhase(game, activePlayerId);
    }

    protected BeginningPhase(BeginningPhase phase) {
        super(phase);
        this.isExtra = phase.isExtra;
    }

    @Override
    public BeginningPhase copy() {
        return new BeginningPhase(this);
    }
}

