/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.turn.Step;

public class CombatDamageStep
extends Step {
    private final boolean first;

    public CombatDamageStep(boolean first) {
        super(first ? PhaseStep.FIRST_COMBAT_DAMAGE : PhaseStep.COMBAT_DAMAGE, true);
        this.stepEvent = GameEvent.EventType.COMBAT_DAMAGE_STEP;
        this.preStepEvent = GameEvent.EventType.COMBAT_DAMAGE_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.COMBAT_DAMAGE_STEP_POST;
        this.first = first;
    }

    protected CombatDamageStep(CombatDamageStep step) {
        super(step);
        this.first = step.first;
    }

    @Override
    public void priority(Game game, UUID activePlayerId, boolean resuming) {
        game.fireEvent(new GameEvent(GameEvent.EventType.COMBAT_DAMAGE_STEP_PRIORITY, null, null, activePlayerId));
        super.priority(game, activePlayerId, resuming);
    }

    @Override
    public boolean skipStep(Game game, UUID activePlayerId) {
        if (game.getCombat().noAttackers()) {
            return true;
        }
        if (this.first && !game.getCombat().hasFirstOrDoubleStrike(game)) {
            return true;
        }
        return super.skipStep(game, activePlayerId);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        super.beginStep(game, activePlayerId);
        for (CombatGroup group : game.getCombat().getGroups()) {
            group.assignDamageToBlockers(this.first, game);
        }
        for (CombatGroup group : game.getCombat().getBlockingGroups()) {
            group.assignDamageToAttackers(this.first, game);
        }
        for (CombatGroup group : game.getCombat().getGroups()) {
            group.applyDamage(game);
        }
        for (CombatGroup group : game.getCombat().getBlockingGroups()) {
            group.applyDamage(game);
        }
        game.getState().addBatchDamageCouldHaveBeenFired(true, game);
        game.getState().handleSimultaneousEvent(game);
    }

    @Override
    public CombatDamageStep copy() {
        return new CombatDamageStep(this);
    }
}

