/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Step;

public class DeclareBlockersStep
extends Step {
    public DeclareBlockersStep() {
        super(PhaseStep.DECLARE_BLOCKERS, true);
        this.stepEvent = GameEvent.EventType.DECLARE_BLOCKERS_STEP;
        this.preStepEvent = GameEvent.EventType.DECLARE_BLOCKERS_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.DECLARE_BLOCKERS_STEP_POST;
    }

    protected DeclareBlockersStep(DeclareBlockersStep step) {
        super(step);
    }

    @Override
    public boolean skipStep(Game game, UUID activePlayerId) {
        if (game.getCombat().noAttackers()) {
            return true;
        }
        return super.skipStep(game, activePlayerId);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        super.beginStep(game, activePlayerId);
        game.getCombat().selectBlockers(game);
        if (!game.isPaused() && !game.executingRollback()) {
            game.getCombat().acceptBlockers(game);
        }
    }

    @Override
    public void resumeBeginStep(Game game, UUID activePlayerId) {
        super.resumeBeginStep(game, activePlayerId);
        game.getCombat().resumeSelectBlockers(game);
        game.getCombat().acceptBlockers(game);
    }

    @Override
    public DeclareBlockersStep copy() {
        return new DeclareBlockersStep(this);
    }
}

