/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.CleanupStep;
import mage.game.turn.EndStep;
import mage.game.turn.Phase;
import mage.game.turn.TurnMod;

public class EndPhase
extends Phase {
    public EndPhase() {
        this.type = TurnPhase.END;
        this.event = GameEvent.EventType.END_PHASE;
        this.preEvent = GameEvent.EventType.END_PHASE_PRE;
        this.postEvent = GameEvent.EventType.END_PHASE_POST;
        this.steps.add(new EndStep());
        this.steps.add(new CleanupStep());
    }

    protected EndPhase(EndPhase phase) {
        super(phase);
    }

    @Override
    protected void playStep(Game game) {
        if (this.currentStep.getType() == PhaseStep.CLEANUP) {
            game.getState().increaseStepNum();
            game.getTurn().setEndTurnRequested(false);
            this.prePriority(game, this.activePlayerId);
            if (game.checkStateAndTriggered()) {
                game.informPlayers("State-based actions or triggers happened on cleanup step, so players get priority due 514.3a");
                game.getState().getTurnMods().add(new TurnMod(this.activePlayerId).withExtraStep(new CleanupStep()));
                if (!(game.isPaused() || game.checkIfGameIsOver() || game.executingRollback())) {
                    this.currentStep.priority(game, this.activePlayerId, false);
                    if (game.executingRollback()) {
                        return;
                    }
                }
            }
            if (!(game.isPaused() || game.checkIfGameIsOver() || game.executingRollback())) {
                this.postPriority(game, this.activePlayerId);
            }
        } else {
            super.playStep(game);
        }
    }

    @Override
    public EndPhase copy() {
        return new EndPhase(this);
    }
}

