/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Step;
import mage.game.turn.TurnMod;
import mage.players.Player;

public abstract class Phase
implements Serializable {
    protected TurnPhase type;
    protected List<Step> steps = new ArrayList<Step>();
    protected GameEvent.EventType event;
    protected GameEvent.EventType preEvent;
    protected GameEvent.EventType postEvent;
    protected UUID activePlayerId;
    protected Step currentStep;
    protected int count;

    public abstract Phase copy();

    public Phase() {
    }

    protected Phase(Phase phase) {
        this.type = phase.type;
        this.event = phase.event;
        this.preEvent = phase.preEvent;
        this.postEvent = phase.postEvent;
        this.activePlayerId = phase.activePlayerId;
        if (phase.currentStep != null) {
            this.currentStep = phase.currentStep.copy();
        }
        this.count = phase.count;
        for (Step step : phase.steps) {
            this.steps.add(step.copy());
        }
    }

    public TurnPhase getType() {
        return this.type;
    }

    public Step getStep() {
        return this.currentStep;
    }

    public void setStep(Step step) {
        this.currentStep = step;
    }

    public void resetCount() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public boolean play(Game game, UUID activePlayerId) {
        if (game.isPaused() || game.checkIfGameIsOver()) {
            return false;
        }
        this.activePlayerId = activePlayerId;
        if (this.beginPhase(game, activePlayerId)) {
            for (Step step : this.steps) {
                if (game.isPaused() || game.checkIfGameIsOver()) {
                    return false;
                }
                if (game.getTurn().isEndTurnRequested() && step.getType() != PhaseStep.CLEANUP) continue;
                this.currentStep = step;
                TurnMod skipStepMod = game.getState().getTurnMods().useNextSkipStep(activePlayerId, this.getStep().getType());
                if (skipStepMod == null) {
                    this.playStep(game);
                    if (game.executingRollback()) {
                        return true;
                    }
                } else {
                    Player player = game.getPlayer(skipStepMod.getPlayerId());
                    if (player != null) {
                        game.informPlayers(String.format("%s skips %s step%s", player.getLogName(), skipStepMod.getSkipStep().toString(), skipStepMod.getInfo()));
                    }
                }
                if (game.isSimulation() || !this.checkStopOnStepOption(game)) continue;
                return false;
            }
            if (game.isPaused() || game.checkIfGameIsOver()) {
                return false;
            }
            ++this.count;
            this.endPhase(game, activePlayerId);
            return true;
        }
        return false;
    }

    private boolean checkStopOnStepOption(Game game) {
        if (game.getOptions().stopOnTurn != null && game.getOptions().stopOnTurn <= game.getState().getTurnNum() && game.getOptions().stopAtStep == this.getStep().getType()) {
            game.pause();
            return true;
        }
        return false;
    }

    public boolean resumePlay(Game game, PhaseStep stepType, boolean wasPaused) {
        Step step;
        if (game.isPaused() || game.checkIfGameIsOver()) {
            return false;
        }
        this.activePlayerId = game.getActivePlayerId();
        Iterator<Step> it = this.steps.iterator();
        do {
            this.currentStep = step = it.next();
        } while (step.getType() != stepType);
        this.resumeStep(game, wasPaused);
        while (it.hasNext()) {
            step = it.next();
            if (game.isPaused() || game.checkIfGameIsOver()) {
                return false;
            }
            this.currentStep = step;
            TurnMod skipStepMod = game.getState().getTurnMods().useNextSkipStep(this.activePlayerId, this.currentStep.getType());
            if (skipStepMod == null) {
                this.playStep(game);
                if (!game.executingRollback()) continue;
                return true;
            }
            Player player = game.getPlayer(skipStepMod.getPlayerId());
            if (player == null) continue;
            game.informPlayers(String.format("%s skips %s step%s", player.getLogName(), skipStepMod.getSkipStep().toString(), skipStepMod.getInfo()));
        }
        if (game.isPaused() || game.checkIfGameIsOver()) {
            return false;
        }
        ++this.count;
        this.endPhase(game, this.activePlayerId);
        return true;
    }

    public boolean beginPhase(Game game, UUID activePlayerId) {
        if (!game.replaceEvent(new GameEvent(this.event, null, null, activePlayerId))) {
            game.fireEvent(new GameEvent(this.preEvent, null, null, activePlayerId));
            return true;
        }
        return false;
    }

    public void endPhase(Game game, UUID activePlayerId) {
        game.fireEvent(new GameEvent(this.postEvent, null, null, activePlayerId));
        game.getState().getTriggers().removeAbilitiesOfNonExistingSources(game);
    }

    public void prePriority(Game game, UUID activePlayerId) {
        this.currentStep.beginStep(game, activePlayerId);
    }

    public void postPriority(Game game, UUID activePlayerId) {
        this.currentStep.endStep(game, activePlayerId);
        game.emptyManaPools(null);
        this.playExtraSteps(game, this.currentStep.getType());
    }

    protected void playStep(Game game) {
        if (!this.currentStep.skipStep(game, this.activePlayerId)) {
            game.getState().increaseStepNum();
            this.prePriority(game, this.activePlayerId);
            if (!(game.isPaused() || game.checkIfGameIsOver() || game.executingRollback())) {
                this.currentStep.priority(game, this.activePlayerId, false);
                if (game.executingRollback()) {
                    return;
                }
            }
            if (!(game.isPaused() || game.checkIfGameIsOver() || game.executingRollback())) {
                this.postPriority(game, this.activePlayerId);
            }
        }
    }

    protected void resumeStep(Game game, boolean wasPaused) {
        boolean resuming = true;
        if (this.currentStep == null || this.currentStep.getStepPart() == null) {
            game.end();
            return;
        }
        switch (this.currentStep.getStepPart()) {
            case PRE: {
                if (wasPaused) {
                    this.currentStep.resumeBeginStep(game, this.activePlayerId);
                    resuming = false;
                } else {
                    this.prePriority(game, this.activePlayerId);
                }
            }
            case PRIORITY: {
                if (!game.isPaused() && !game.checkIfGameIsOver()) {
                    this.currentStep.priority(game, this.activePlayerId, resuming);
                }
            }
            case POST: {
                if (game.isPaused() || game.checkIfGameIsOver()) break;
                this.postPriority(game, this.activePlayerId);
            }
        }
    }

    private void playExtraSteps(Game game, PhaseStep afterStep) {
        while (true) {
            TurnMod extraStepMod;
            if ((extraStepMod = game.getState().getTurnMods().useNextExtraStep(this.activePlayerId, afterStep)) == null) {
                return;
            }
            this.currentStep = extraStepMod.getExtraStep();
            Player player = game.getPlayer(extraStepMod.getPlayerId());
            if (player == null || !player.canRespond()) break;
            game.informPlayers(String.format("%s takes an extra %s step%s", player.getLogName(), extraStepMod.getExtraStep().toString(), extraStepMod.getInfo()));
            this.playStep(game);
        }
    }

    public void keepOnlyStep(PhaseStep step) {
        if (this.count != 0) {
            throw new IllegalStateException("Wrong code usage: illegal Phase modification once it started running");
        }
        this.steps = this.steps.stream().filter(s -> s.getType().equals((Object)step)).collect(Collectors.toList());
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Wrong code usage: keepOnlyStep should not remove all the steps in a phase - " + (Object)((Object)step));
        }
    }

    public String toString() {
        return this.type.toString();
    }
}

