/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.io.Serializable;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.Step;
import mage.util.CardUtil;
import mage.util.Copyable;

public class TurnMod
implements Serializable,
Copyable<TurnMod> {
    private final UUID id;
    private final UUID playerId;
    private UUID newControllerId;
    private boolean extraTurn;
    private boolean skipTurn;
    private TurnPhase extraPhase;
    private TurnPhase skipPhase;
    private Step extraStep;
    private PhaseStep skipStep;
    private PhaseStep skipAllButExtraStep;
    private TurnPhase afterPhase;
    private PhaseStep afterStep;
    private boolean locked = false;
    private String tag;
    private String info;
    private TurnMod subsequentTurnMod;

    private TurnMod(TurnMod mod) {
        this.id = mod.id;
        this.playerId = mod.playerId;
        this.newControllerId = mod.newControllerId;
        this.extraTurn = mod.extraTurn;
        this.skipTurn = mod.skipTurn;
        this.extraPhase = mod.extraPhase;
        this.skipPhase = mod.skipPhase;
        if (mod.extraStep != null) {
            this.extraStep = mod.extraStep.copy();
        }
        this.skipStep = mod.skipStep;
        this.skipAllButExtraStep = mod.skipAllButExtraStep;
        this.afterPhase = mod.afterPhase;
        this.afterStep = mod.afterStep;
        if (mod.subsequentTurnMod != null) {
            this.subsequentTurnMod = mod.subsequentTurnMod.copy();
        }
        this.tag = mod.tag;
        this.info = mod.info;
        this.locked = mod.locked;
    }

    @Override
    public TurnMod copy() {
        return new TurnMod(this);
    }

    public TurnMod(UUID playerId) {
        this.id = UUID.randomUUID();
        this.playerId = playerId;
    }

    private void lock() {
        if (this.locked) {
            throw new IllegalStateException("Wrong code usage: you must use only one type of turn modification");
        }
        this.locked = true;
    }

    public TurnMod withSkipTurn() {
        this.skipTurn = true;
        this.lock();
        return this;
    }

    public TurnMod withExtraTurn() {
        this.extraTurn = true;
        this.lock();
        return this;
    }

    public TurnMod withNewController(UUID newControllerId) {
        return this.withNewController(newControllerId, null);
    }

    public TurnMod withNewController(UUID newControllerId, TurnMod nextSubsequentTurnMod) {
        this.newControllerId = newControllerId;
        this.subsequentTurnMod = nextSubsequentTurnMod;
        this.lock();
        return this;
    }

    public TurnMod withSkipPhase(TurnPhase skipPhase) {
        this.skipPhase = skipPhase;
        this.lock();
        return this;
    }

    public TurnMod withExtraPhase(TurnPhase extraPhase) {
        return this.withExtraPhase(extraPhase, null);
    }

    public TurnMod withExtraStepInExtraPhase(PhaseStep extraStep, TurnPhase extraPhase) {
        this.extraPhase = extraPhase;
        this.skipAllButExtraStep = extraStep;
        this.lock();
        return this;
    }

    public TurnMod withExtraPhase(TurnPhase extraPhase, TurnPhase addAfterPhase) {
        this.extraPhase = extraPhase;
        this.afterPhase = addAfterPhase;
        this.lock();
        return this;
    }

    public TurnMod withSkipStep(PhaseStep skipStep) {
        this.skipStep = skipStep;
        this.lock();
        return this;
    }

    public TurnMod withExtraStep(Step extraStep) {
        return this.withExtraStep(extraStep, null);
    }

    public TurnMod withExtraStep(Step extraStep, PhaseStep addAfterStep) {
        this.extraStep = extraStep;
        this.afterStep = addAfterStep;
        this.lock();
        return this;
    }

    public TurnMod withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public TurnMod withInfo(String info) {
        this.info = info;
        return this;
    }

    public String getInfo() {
        return this.info == null ? "" : this.info;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isExtraTurn() {
        return this.extraTurn;
    }

    public boolean isSkipTurn() {
        return this.skipTurn;
    }

    public TurnPhase getExtraPhase() {
        return this.extraPhase;
    }

    public Step getExtraStep() {
        return this.extraStep;
    }

    public TurnPhase getSkipPhase() {
        return this.skipPhase;
    }

    public PhaseStep getSkipAllButExtraStep() {
        return this.skipAllButExtraStep;
    }

    public PhaseStep getSkipStep() {
        return this.skipStep;
    }

    public TurnPhase getAfterPhase() {
        return this.afterPhase;
    }

    public PhaseStep getAfterStep() {
        return this.afterStep;
    }

    public UUID getNewControllerId() {
        return this.newControllerId;
    }

    public UUID getId() {
        return this.id;
    }

    public TurnMod getSubsequentTurnMod() {
        return this.subsequentTurnMod;
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void addSourceAsInfo(Game game, Ability source) {
        this.info = CardUtil.getSourceLogName(game, source);
    }
}

