/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.UUID;
import mage.ConditionalMana;
import mage.Emptiable;
import mage.MageObject;
import mage.Mana;
import mage.constants.Duration;
import mage.constants.ManaType;

public class ManaPoolItem
implements Serializable,
Emptiable {
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private int white = 0;
    private int black = 0;
    private int colorless = 0;
    private ConditionalMana conditionalMana;
    private MageObject sourceObject;
    private UUID originalId;
    private boolean flag = false;
    private Duration duration;
    private int stock;

    public ManaPoolItem() {
    }

    public ManaPoolItem(int red, int green, int blue, int white, int black, int colorless, MageObject sourceObject, UUID originalId, boolean flag) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.white = white;
        this.black = black;
        this.colorless = colorless;
        this.sourceObject = sourceObject;
        this.originalId = originalId;
        this.flag = flag;
        this.duration = Duration.EndOfStep;
    }

    public ManaPoolItem(ConditionalMana conditionalMana, MageObject sourceObject, UUID originalId) {
        this.conditionalMana = conditionalMana;
        this.sourceObject = sourceObject;
        this.originalId = originalId;
        this.conditionalMana.setManaProducerId(sourceObject.getId());
        this.conditionalMana.setManaProducerOriginalId(originalId);
        this.flag = conditionalMana.getFlag();
        this.duration = Duration.EndOfStep;
    }

    protected ManaPoolItem(ManaPoolItem item) {
        this.red = item.red;
        this.green = item.green;
        this.blue = item.blue;
        this.white = item.white;
        this.black = item.black;
        this.colorless = item.colorless;
        if (item.conditionalMana != null) {
            this.conditionalMana = item.conditionalMana.copy();
        }
        this.sourceObject = item.sourceObject;
        this.originalId = item.originalId;
        this.flag = item.flag;
        this.duration = item.duration;
        this.stock = item.stock;
    }

    public ManaPoolItem copy() {
        return new ManaPoolItem(this);
    }

    public MageObject getSourceObject() {
        return this.sourceObject;
    }

    public UUID getSourceId() {
        if (this.sourceObject != null) {
            return this.sourceObject.getId();
        }
        return null;
    }

    public UUID getOriginalId() {
        return this.originalId;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public int getRed() {
        return this.red;
    }

    public void removeRed() {
        if (this.red > 0) {
            --this.red;
        }
    }

    public int getGreen() {
        return this.green;
    }

    public void removeGreen() {
        if (this.green > 0) {
            --this.green;
        }
    }

    public int getBlue() {
        return this.blue;
    }

    public void removeBlue() {
        if (this.blue > 0) {
            --this.blue;
        }
    }

    public int getBlack() {
        return this.black;
    }

    public void removeBlack() {
        if (this.black > 0) {
            --this.black;
        }
    }

    public int getWhite() {
        return this.white;
    }

    public void removeWhite() {
        if (this.white > 0) {
            --this.white;
        }
    }

    public int getColorless() {
        return this.colorless;
    }

    public void removeColorless() {
        if (this.colorless > 0) {
            --this.colorless;
        }
    }

    public boolean isConditional() {
        return this.conditionalMana != null;
    }

    public ConditionalMana getConditionalMana() {
        return this.conditionalMana;
    }

    public Mana getMana() {
        return new Mana(this.white, this.blue, this.black, this.red, this.green, 0, 0, this.colorless);
    }

    public int count() {
        if (this.conditionalMana == null) {
            return this.red + this.green + this.blue + this.white + this.black + this.colorless;
        }
        return this.conditionalMana.count();
    }

    @Override
    public int get(ManaType manaType) {
        switch (manaType) {
            case BLACK: {
                return this.black;
            }
            case BLUE: {
                return this.blue;
            }
            case GREEN: {
                return this.green;
            }
            case RED: {
                return this.red;
            }
            case WHITE: {
                return this.white;
            }
            case COLORLESS: {
                return this.colorless;
            }
        }
        return 0;
    }

    public ManaType getFirstAvailable() {
        if (this.black > 0) {
            return ManaType.BLACK;
        }
        if (this.blue > 0) {
            return ManaType.BLUE;
        }
        if (this.green > 0) {
            return ManaType.GREEN;
        }
        if (this.red > 0) {
            return ManaType.RED;
        }
        if (this.white > 0) {
            return ManaType.WHITE;
        }
        if (this.colorless > 0) {
            return ManaType.COLORLESS;
        }
        if (this.conditionalMana != null) {
            if (this.conditionalMana.getBlack() > 0) {
                return ManaType.BLACK;
            }
            if (this.conditionalMana.getBlue() > 0) {
                return ManaType.BLUE;
            }
            if (this.conditionalMana.getGreen() > 0) {
                return ManaType.GREEN;
            }
            if (this.conditionalMana.getRed() > 0) {
                return ManaType.RED;
            }
            if (this.conditionalMana.getWhite() > 0) {
                return ManaType.WHITE;
            }
            if (this.conditionalMana.getColorless() > 0) {
                return ManaType.COLORLESS;
            }
        }
        return null;
    }

    public void remove(ManaType manaType) {
        int oldCount = this.count();
        switch (manaType) {
            case BLACK: {
                if (this.black <= 0) break;
                --this.black;
                break;
            }
            case BLUE: {
                if (this.blue <= 0) break;
                --this.blue;
                break;
            }
            case GREEN: {
                if (this.green <= 0) break;
                --this.green;
                break;
            }
            case RED: {
                if (this.red <= 0) break;
                --this.red;
                break;
            }
            case WHITE: {
                if (this.white <= 0) break;
                --this.white;
                break;
            }
            case COLORLESS: {
                if (this.colorless <= 0) break;
                --this.colorless;
            }
        }
        if (this.stock == oldCount && oldCount > this.count()) {
            --this.stock;
        }
    }

    @Override
    public void clear(ManaType manaType) {
        switch (manaType) {
            case BLACK: {
                this.black = 0;
                break;
            }
            case BLUE: {
                this.blue = 0;
                break;
            }
            case GREEN: {
                this.green = 0;
                break;
            }
            case RED: {
                this.red = 0;
                break;
            }
            case WHITE: {
                this.white = 0;
                break;
            }
            case COLORLESS: {
                this.colorless = 0;
            }
        }
    }

    @Override
    public void add(ManaType manaType, int amount) {
        switch (manaType) {
            case BLACK: {
                this.black += amount;
                break;
            }
            case BLUE: {
                this.blue += amount;
                break;
            }
            case GREEN: {
                this.green += amount;
                break;
            }
            case RED: {
                this.red += amount;
                break;
            }
            case WHITE: {
                this.white += amount;
                break;
            }
            case COLORLESS: {
                this.colorless += amount;
            }
        }
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public int getStock() {
        return this.stock;
    }

    public void setStock(int stock) {
        this.stock = stock;
    }
}

