/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

public enum PlayerType {
    HUMAN("Human", false, true),
    COMPUTER_DRAFT_BOT("Computer - draftbot", true, false),
    COMPUTER_MONTE_CARLO("Computer - monte carlo", true, true),
    COMPUTER_MAD("Computer - mad", true, true);

    final String description;
    final boolean isAI;
    final boolean isWorkablePlayer;

    private PlayerType(String description, boolean isAI, boolean isWorkablePlayer) {
        this.description = description;
        this.isAI = isAI;
        this.isWorkablePlayer = isWorkablePlayer;
    }

    public String toString() {
        return this.description;
    }

    public boolean isAI() {
        return this.isAI;
    }

    public boolean isWorkablePlayer() {
        return this.isWorkablePlayer;
    }

    public static PlayerType getByDescription(String description) {
        for (PlayerType type : PlayerType.values()) {
            if (!type.description.equals(description)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("PlayerType (%s) is not configured in server's config.xml", description));
    }
}

