/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.Copyable;

public interface Target
extends Copyable<Target>,
Serializable {
    @Deprecated
    public boolean isChosen(Game var1);

    public boolean isChoiceCompleted(UUID var1, Ability var2, Game var3, Cards var4);

    public boolean isSkipChoice();

    public void setSkipChoice(boolean var1);

    public void clearChosen();

    public boolean isChoiceSelected();

    public boolean isNotTarget();

    public Target withNotTarget(boolean var1);

    public boolean canChoose(UUID var1, Ability var2, Game var3);

    default public boolean canChooseOrAlreadyChosen(UUID sourceControllerId, Ability source, Game game) {
        return this.isChosen(game) || this.canChoose(sourceControllerId, source, game);
    }

    default public boolean canChooseFromPossibleTargets(UUID sourceControllerId, Ability source, Game game) {
        if (this.getMinNumberOfTargets() == 0) {
            return true;
        }
        int selectedCount = this.getSize();
        int moreSelectCount = this.possibleTargets(sourceControllerId, source, game).size();
        if (selectedCount >= this.getMaxNumberOfTargets()) {
            return false;
        }
        return moreSelectCount > 0 && selectedCount + moreSelectCount >= this.getMinNumberOfTargets();
    }

    public Set<UUID> possibleTargets(UUID var1, Ability var2, Game var3);

    default public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game, Set<UUID> cards) {
        return this.possibleTargets(sourceControllerId, source, game).stream().filter(id -> cards == null || cards.contains(id)).collect(Collectors.toSet());
    }

    default public Set<UUID> keepValidPossibleTargets(Set<UUID> possibleTargets, UUID sourceControllerId, Ability source, Game game) {
        return possibleTargets.stream().filter(this::notContains).filter(targetId -> {
            if (source == null || source.getSourceId() == null || this.isNotTarget()) {
                return true;
            }
            MageObject sourceObject = game.getObject(source);
            if (sourceObject == null) {
                return true;
            }
            Player targetPlayer = game.getPlayer((UUID)targetId);
            if (targetPlayer != null) {
                return !targetPlayer.hasLeft() && this.canTarget(sourceControllerId, (UUID)targetId, source, game) && targetPlayer.canBeTargetedBy(sourceObject, sourceControllerId, source, game);
            }
            Permanent targetPermanent = game.getPermanent((UUID)targetId);
            if (targetPermanent != null) {
                return this.canTarget(sourceControllerId, (UUID)targetId, source, game) && targetPermanent.canBeTargetedBy(sourceObject, sourceControllerId, source, game);
            }
            return true;
        }).collect(Collectors.toSet());
    }

    public boolean chooseTarget(Outcome var1, UUID var2, Ability var3, Game var4);

    public void addTarget(UUID var1, Ability var2, Game var3);

    public void addTarget(UUID var1, int var2, Ability var3, Game var4);

    public void addTarget(UUID var1, Ability var2, Game var3, boolean var4);

    public void addTarget(UUID var1, int var2, Ability var3, Game var4, boolean var5);

    public boolean canTarget(UUID var1, Ability var2, Game var3);

    public boolean stillLegalTarget(UUID var1, UUID var2, Ability var3, Game var4);

    public boolean canTarget(UUID var1, UUID var2, Ability var3, Game var4);

    public boolean isLegal(Ability var1, Game var2);

    public List<? extends Target> getTargetOptions(Ability var1, Game var2);

    default public boolean canChoose(UUID sourceControllerId, Game game) {
        return this.canChoose(sourceControllerId, null, game);
    }

    @Deprecated
    public boolean choose(Outcome var1, UUID var2, UUID var3, Ability var4, Game var5);

    default public boolean choose(Outcome outcome, UUID playerId, Ability source, Game game) {
        return this.choose(outcome, playerId, source == null ? null : source.getSourceId(), source, game);
    }

    public void add(UUID var1, Game var2);

    public void remove(UUID var1);

    public void updateTarget(UUID var1, Game var2);

    public String getDescription();

    public String getMessage(Game var1);

    public String getTargetName();

    public Target withTargetName(String var1);

    public String getTargetedName(Game var1);

    public Zone getZone();

    public int getTargetAmount(UUID var1);

    public int getMinNumberOfTargets();

    public int getMaxNumberOfTargets();

    public void setMinNumberOfTargets(int var1);

    public void setMaxNumberOfTargets(int var1);

    public List<UUID> getTargets();

    public Filter getFilter();

    public boolean isRequired();

    public boolean isRequired(UUID var1, Game var2);

    public boolean isRequired(Ability var1);

    public void setRequired(boolean var1);

    public boolean isRequiredExplicitlySet();

    public boolean isRandom();

    public void setRandom(boolean var1);

    public UUID getFirstTarget();

    @Override
    public Target copy();

    @Deprecated
    public void setTargetController(UUID var1);

    public UUID getTargetController();

    @Deprecated
    public void setAbilityController(UUID var1);

    public UUID getAbilityController();

    public UUID getAffectedAbilityControllerId(UUID var1);

    public Player getTargetController(Game var1, UUID var2);

    public int getTargetTag();

    public Target setTargetTag(int var1);

    public Target getOriginalTarget();

    public void setTargetAmount(UUID var1, int var2, Game var3);

    public Target withChooseHint(String var1);

    public String getChooseHint();

    public void setEventReporting(boolean var1);

    public int getSize();

    public boolean contains(UUID var1);

    default public boolean notContains(UUID targetId) {
        return !this.contains(targetId);
    }

    public UUID tryToAutoChoose(UUID var1, Ability var2, Game var3);

    public UUID tryToAutoChoose(UUID var1, Ability var2, Game var3, Collection<UUID> var4);
}

