/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TargetEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetOptimization;
import mage.util.CardUtil;
import mage.util.RandomUtil;

public abstract class TargetImpl
implements Target {
    protected final Map<UUID, Integer> targets = new LinkedHashMap<UUID, Integer>();
    protected final Map<UUID, Integer> zoneChangeCounters = new HashMap<UUID, Integer>();
    protected String targetName;
    protected Zone zone;
    protected int maxNumberOfTargets;
    protected int minNumberOfTargets;
    protected boolean required = true;
    protected boolean requiredExplicitlySet = false;
    protected boolean chosen = false;
    protected boolean isSkipChoice = false;
    protected boolean notTarget = false;
    protected boolean atRandom = false;
    protected UUID targetController = null;
    protected UUID abilityController = null;
    protected int targetTag;
    protected String chooseHint = null;
    protected boolean shouldReportEvents = true;

    @Override
    public abstract TargetImpl copy();

    protected TargetImpl() {
        this(false);
    }

    protected TargetImpl(boolean notTarget) {
        this.notTarget = notTarget;
    }

    protected TargetImpl(TargetImpl target) {
        this.targetName = target.targetName;
        this.zone = target.zone;
        this.maxNumberOfTargets = target.maxNumberOfTargets;
        this.minNumberOfTargets = target.minNumberOfTargets;
        this.required = target.required;
        this.requiredExplicitlySet = target.requiredExplicitlySet;
        this.chosen = target.chosen;
        this.isSkipChoice = target.isSkipChoice;
        this.targets.putAll(target.targets);
        this.zoneChangeCounters.putAll(target.zoneChangeCounters);
        this.atRandom = target.atRandom;
        this.notTarget = target.notTarget;
        this.targetController = target.targetController;
        this.abilityController = target.abilityController;
        this.targetTag = target.targetTag;
        this.chooseHint = target.chooseHint;
        this.shouldReportEvents = target.shouldReportEvents;
    }

    @Override
    public int getMinNumberOfTargets() {
        return this.minNumberOfTargets;
    }

    @Override
    public int getMaxNumberOfTargets() {
        return this.maxNumberOfTargets;
    }

    @Override
    public void setMinNumberOfTargets(int minNumberOftargets) {
        this.minNumberOfTargets = minNumberOftargets;
    }

    @Override
    public void setMaxNumberOfTargets(int maxNumberOftargets) {
        this.maxNumberOfTargets = maxNumberOftargets;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        int min = this.getMinNumberOfTargets();
        int max = this.getMaxNumberOfTargets();
        String targetName = this.getTargetName();
        if (min > 0 && max == Integer.MAX_VALUE) {
            sb.append(CardUtil.numberToText(min));
            sb.append(" or more ");
        } else if (!(targetName.startsWith("X ") || targetName.startsWith("up to ") || min == 1 && max == 1)) {
            targetName = targetName.replace("another", "other");
            if (this.getUseAnyNumber()) {
                sb.append("any number of ");
            } else {
                if (min < max && max != Integer.MAX_VALUE) {
                    if (min == 1 && max == 2) {
                        sb.append("one or ");
                    } else if (min == 1 && max == 3) {
                        sb.append("one, two, or ");
                    } else {
                        sb.append("up to ");
                    }
                }
                sb.append(CardUtil.numberToText(max));
                sb.append(' ');
            }
        }
        boolean addTargetWord = false;
        if (!this.isNotTarget()) {
            addTargetWord = true;
            if (targetName.contains("target ")) {
                addTargetWord = false;
            } else if (targetName.endsWith("any target") || targetName.endsWith("any other target") || targetName.endsWith("targets")) {
                addTargetWord = false;
            }
        }
        if (addTargetWord) {
            sb.append("target ");
        }
        if (this.isNotTarget() && min == 1 && max == 1) {
            sb.append(CardUtil.addArticle(targetName));
        } else {
            sb.append(targetName);
        }
        return sb.toString();
    }

    protected boolean getUseAnyNumber() {
        int min = this.getMinNumberOfTargets();
        int max = this.getMaxNumberOfTargets();
        return min == 0 && max == Integer.MAX_VALUE;
    }

    @Override
    public boolean isSkipChoice() {
        return this.isSkipChoice;
    }

    @Override
    public void setSkipChoice(boolean isSkipChoice) {
        this.isSkipChoice = isSkipChoice;
    }

    @Override
    public String getMessage(Game game) {
        String suffix = "";
        if (this.chooseHint != null) {
            suffix = " (" + this.chooseHint + ")";
        }
        if (this.getMaxNumberOfTargets() != 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Select ").append(this.targetName);
            sb.append(" (selected ").append(this.targets.size());
            if (this.getMaxNumberOfTargets() > 0 && this.getMaxNumberOfTargets() != Integer.MAX_VALUE) {
                sb.append(" of ").append(this.getMaxNumberOfTargets());
            }
            if (this.getMinNumberOfTargets() > 0) {
                sb.append(", min ").append(this.getMinNumberOfTargets());
            }
            sb.append(')');
            sb.append(suffix);
            return sb.toString();
        }
        if (this.getMinNumberOfTargets() == 0 && this.getMaxNumberOfTargets() == 1) {
            return "Select up to one " + this.targetName + suffix;
        }
        return "Select " + CardUtil.addArticle(this.targetName) + suffix;
    }

    @Override
    public boolean isNotTarget() {
        return this.notTarget;
    }

    @Override
    public String getTargetName() {
        return this.targetName + (this.isRandom() ? " chosen at random" : "");
    }

    @Override
    public TargetImpl withTargetName(String name) {
        this.targetName = name;
        return this;
    }

    @Override
    public Zone getZone() {
        return this.zone;
    }

    @Override
    public boolean isRequired(UUID sourceId, Game game) {
        MageObject object = game.getObject(sourceId);
        if (!this.requiredExplicitlySet && object instanceof Ability) {
            return this.isRequired((Ability)((Object)object));
        }
        return this.isRequired();
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isRequired(Ability ability) {
        return ability == null || ability.isActivated() || ability.getAbilityType() != AbilityType.SPELL && !ability.getAbilityType().isActivatedAbility();
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
        this.requiredExplicitlySet = true;
    }

    @Override
    public boolean isChosen(Game game) {
        if (this.getMaxNumberOfTargets() == 0 && this.getMinNumberOfTargets() == 0) {
            return true;
        }
        if (this.getMaxNumberOfTargets() > 0 && this.targets.size() > this.getMaxNumberOfTargets()) {
            return false;
        }
        if (this.getMinNumberOfTargets() > 0 && this.targets.size() < this.getMinNumberOfTargets()) {
            return false;
        }
        return this.chosen || this.targets.size() >= this.getMinNumberOfTargets() && this.targets.size() <= this.getMaxNumberOfTargets();
    }

    @Override
    public boolean isChoiceCompleted(UUID abilityControllerId, Ability source, Game game, Cards fromCards) {
        if (!this.isChoiceSelected()) {
            return false;
        }
        if (!this.isChosen(game)) {
            return false;
        }
        if (this.getSize() >= this.getMaxNumberOfTargets()) {
            return true;
        }
        if (this.getMaxNumberOfTargets() > 0) {
            if (this.getSize() >= this.getMaxNumberOfTargets()) {
                return true;
            }
            int moreSelectCount = this.possibleTargets(abilityControllerId, source, game, fromCards).size();
            return moreSelectCount == 0 || this.isSkipChoice();
        }
        return true;
    }

    @Override
    public void clearChosen() {
        this.targets.clear();
        this.zoneChangeCounters.clear();
        this.chosen = false;
        this.isSkipChoice = false;
    }

    @Override
    public boolean isChoiceSelected() {
        return this.chosen || this.getMaxNumberOfTargets() == 0 && this.getMinNumberOfTargets() == 0 || this.isSkipChoice();
    }

    @Override
    public void add(UUID id, Game game) {
        if (!(this.getMaxNumberOfTargets() != 0 && this.targets.size() >= this.getMaxNumberOfTargets() || this.targets.containsKey(id))) {
            this.targets.put(id, 0);
            this.rememberZoneChangeCounter(id, game);
            this.chosen = this.isChosen(game);
        }
    }

    @Override
    public void remove(UUID id) {
        if (this.targets.containsKey(id)) {
            this.targets.remove(id);
            this.zoneChangeCounters.remove(id);
        }
    }

    @Override
    public void addTarget(UUID id, Ability source, Game game) {
        this.addTarget(id, source, game, this.notTarget);
    }

    @Override
    public void addTarget(UUID id, Ability source, Game game, boolean skipEvent) {
        if (!(this.getMaxNumberOfTargets() != 0 && this.targets.size() >= this.getMaxNumberOfTargets() || this.targets.containsKey(id))) {
            if (source != null && !skipEvent && this.shouldReportEvents) {
                if (!game.replaceEvent(new TargetEvent(id, source))) {
                    this.targets.put(id, 0);
                    this.rememberZoneChangeCounter(id, game);
                    this.chosen = this.isChosen(game);
                    if (!skipEvent && this.shouldReportEvents) {
                        game.addSimultaneousEvent(GameEvent.getEvent(GameEvent.EventType.TARGETED, id, source, source.getControllerId()));
                    }
                }
            } else {
                this.targets.put(id, 0);
                this.rememberZoneChangeCounter(id, game);
                this.chosen = this.isChosen(game);
            }
        }
    }

    @Override
    public void updateTarget(UUID id, Game game) {
        this.rememberZoneChangeCounter(id, game);
    }

    private void rememberZoneChangeCounter(UUID id, Game game) {
        Card card = game.getCard(id);
        if (card != null) {
            this.zoneChangeCounters.put(id, card.getZoneChangeCounter(game));
        }
    }

    @Override
    public void addTarget(UUID id, int amount, Ability source, Game game) {
        this.addTarget(id, amount, source, game, false);
    }

    @Override
    public void addTarget(UUID id, int amount, Ability source, Game game, boolean skipEvent) {
        if (this.targets.containsKey(id)) {
            amount += this.targets.get(id).intValue();
        }
        if (source != null && !skipEvent && this.shouldReportEvents) {
            if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.TARGET, id, source, source.getControllerId()))) {
                this.targets.put(id, amount);
                this.rememberZoneChangeCounter(id, game);
                this.chosen = this.isChosen(game);
                if (!skipEvent && this.shouldReportEvents) {
                    game.fireEvent(GameEvent.getEvent(GameEvent.EventType.TARGETED, id, source, source.getControllerId()));
                }
            }
        } else {
            this.targets.put(id, amount);
            this.rememberZoneChangeCounter(id, game);
            this.chosen = this.isChosen(game);
        }
    }

    @Override
    public boolean choose(Outcome outcome, UUID playerId, UUID sourceId, Ability source, Game game) {
        int prevTargetsCount;
        Player targetController = this.getTargetController(game, playerId);
        if (targetController == null) {
            return false;
        }
        UUID abilityControllerId = this.getAffectedAbilityControllerId(playerId);
        this.chosen = false;
        do {
            prevTargetsCount = this.getTargets().size();
            if (!targetController.canRespond() || !targetController.choose(outcome, this, source, game)) break;
            this.chosen = this.isChosen(game);
        } while (!this.isChoiceCompleted(abilityControllerId, source, game, null) && prevTargetsCount != this.getTargets().size());
        this.chosen = this.isChosen(game);
        return this.chosen && !this.getTargets().isEmpty();
    }

    @Override
    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        int prevTargetsCount;
        Player targetController = this.getTargetController(game, playerId);
        if (targetController == null) {
            return false;
        }
        UUID abilityControllerId = this.getAffectedAbilityControllerId(playerId);
        ArrayList<UUID> randomPossibleTargets = new ArrayList<UUID>(this.possibleTargets(playerId, source, game));
        this.chosen = false;
        do {
            prevTargetsCount = this.getTargets().size();
            if (!targetController.canRespond()) break;
            if (this.isRandom()) {
                if (randomPossibleTargets.isEmpty()) break;
                while (!randomPossibleTargets.isEmpty()) {
                    UUID possibleTarget = RandomUtil.randomFromCollection(randomPossibleTargets);
                    if (this.canTarget(playerId, possibleTarget, source, game) && !this.contains(possibleTarget)) {
                        this.addTarget(possibleTarget, source, game);
                        randomPossibleTargets.remove(possibleTarget);
                        break;
                    }
                    randomPossibleTargets.remove(possibleTarget);
                }
            } else {
                UUID autoChosenId = this.tryToAutoChoose(playerId, source, game);
                if (autoChosenId != null && !this.contains(autoChosenId)) {
                    this.addTarget(autoChosenId, source, game);
                } else if (!targetController.chooseTarget(outcome, this, source, game)) break;
            }
            this.chosen = this.isChosen(game);
        } while (!this.isChoiceCompleted(abilityControllerId, source, game, null) && prevTargetsCount != this.getTargets().size());
        this.chosen = this.isChosen(game);
        return this.chosen && !this.getTargets().isEmpty();
    }

    @Override
    public boolean isLegal(Ability source, Game game) {
        HashSet<UUID> illegalTargets = new HashSet<UUID>();
        for (UUID targetId : this.targets.keySet()) {
            Card card = game.getCard(targetId);
            if (card != null) {
                Permanent p = game.getPermanent(targetId);
                if (p != null && !p.isPhasedIn()) {
                    illegalTargets.add(targetId);
                    continue;
                }
                if (this.zoneChangeCounters.containsKey(targetId) && this.zoneChangeCounters.get(targetId).intValue() != card.getZoneChangeCounter(game)) {
                    illegalTargets.add(targetId);
                    continue;
                }
            }
            if (!this.notTarget && game.replaceEvent(new TargetEvent(targetId, source))) {
                illegalTargets.add(targetId);
                continue;
            }
            if (this.stillLegalTarget(source.getControllerId(), targetId, source, game)) continue;
            illegalTargets.add(targetId);
        }
        for (UUID targetId : illegalTargets) {
            this.targets.remove(targetId);
        }
        if (this.targets.isEmpty()) {
            if (!illegalTargets.isEmpty()) {
                return false;
            }
            if (this.getMinNumberOfTargets() == 0) {
                return true;
            }
        }
        return !this.targets.isEmpty();
    }

    public List<? extends TargetImpl> getTargetOptions(Ability source, Game game) {
        ArrayList<TargetImpl> options = new ArrayList<TargetImpl>();
        Set<UUID> possibleTargets = this.possibleTargets(source.getControllerId(), source, game);
        int maxPossibleTargetsToSimulate = Math.min(TargetOptimization.AI_MAX_POSSIBLE_TARGETS_TO_CHOOSE, possibleTargets.size());
        if (this.getMinNumberOfTargets() > 0) {
            maxPossibleTargetsToSimulate = Math.max(maxPossibleTargetsToSimulate, this.getMinNumberOfTargets());
        }
        TargetOptimization.printTargetsVariationsForTarget("target - before optimize", game, possibleTargets, options, false);
        TargetOptimization.optimizePossibleTargets(source, game, possibleTargets, maxPossibleTargetsToSimulate);
        TargetOptimization.printTargetsVariationsForTarget("target - after optimize", game, possibleTargets, options, false);
        ArrayList<UUID> needPossibleTargets = new ArrayList<UUID>(possibleTargets);
        int N = needPossibleTargets.size();
        if (N < this.getMinNumberOfTargets()) {
            return options;
        }
        if (N == 0) {
            TargetImpl target = this.copy();
            target.setSkipChoice(true);
            options.add(target);
            return options;
        }
        int maxK = this.getMaxNumberOfTargets() - this.getTargets().size();
        if (maxK > 5) {
            maxK = 5;
            if (N > 10) {
                maxK = 4;
            }
            if (N > 20) {
                maxK = 3;
            }
        }
        if (N < maxK) {
            maxK = N;
        }
        int minK = this.getMinNumberOfTargets();
        if (this.getMinNumberOfTargets() == 0) {
            TargetImpl target = this.copy();
            target.setSkipChoice(true);
            options.add(target);
            minK = 1;
        }
        for (int K = minK; K <= maxK; ++K) {
            int[] combination = new int[K];
            int r = 0;
            int index = 0;
            while (r >= 0) {
                if (index <= N + (r - K)) {
                    combination[r] = index;
                    if (r == K - 1) {
                        TargetImpl target = this.copy();
                        for (int i = 0; i < combination.length; ++i) {
                            target.addTarget((UUID)needPossibleTargets.get(combination[i]), source, game, true);
                        }
                        options.add(target);
                        ++index;
                        continue;
                    }
                    index = combination[r] + 1;
                    ++r;
                    continue;
                }
                if (--r > 0) {
                    index = combination[r] + 1;
                    continue;
                }
                index = combination[0] + 1;
            }
        }
        TargetOptimization.printTargetsVariationsForTarget("target - after calc", game, possibleTargets, options, true);
        return options;
    }

    @Override
    public List<UUID> getTargets() {
        return new ArrayList<UUID>(this.targets.keySet());
    }

    @Override
    public int getTargetAmount(UUID targetId) {
        if (this.targets.containsKey(targetId)) {
            return this.targets.get(targetId);
        }
        return 0;
    }

    @Override
    public UUID getFirstTarget() {
        if (!this.targets.isEmpty()) {
            return this.targets.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public boolean stillLegalTarget(UUID controllerId, UUID id, Ability source, Game game) {
        return this.canTarget(controllerId, id, source, game);
    }

    @Override
    public TargetImpl withNotTarget(boolean notTarget) {
        this.notTarget = notTarget;
        return this;
    }

    @Override
    public boolean isRandom() {
        return this.atRandom;
    }

    @Override
    public void setRandom(boolean atRandom) {
        this.atRandom = atRandom;
    }

    @Override
    public void setTargetController(UUID playerId) {
        this.targetController = playerId;
    }

    @Override
    public UUID getTargetController() {
        return this.targetController;
    }

    @Override
    public void setAbilityController(UUID playerId) {
        this.abilityController = playerId;
    }

    @Override
    public UUID getAbilityController() {
        return this.abilityController;
    }

    @Override
    public UUID getAffectedAbilityControllerId(UUID choosingPlayerId) {
        UUID abilityControllerId = choosingPlayerId;
        if (this.getAbilityController() != null) {
            abilityControllerId = this.getAbilityController();
        }
        return abilityControllerId;
    }

    @Override
    public Player getTargetController(Game game, UUID playerId) {
        if (this.getTargetController() != null) {
            return game.getPlayer(this.getTargetController());
        }
        return game.getPlayer(playerId);
    }

    @Override
    public boolean isRequiredExplicitlySet() {
        return this.requiredExplicitlySet;
    }

    @Override
    public int getTargetTag() {
        return this.targetTag;
    }

    @Override
    public TargetImpl setTargetTag(int targetTag) {
        this.targetTag = targetTag;
        return this;
    }

    @Override
    public Target getOriginalTarget() {
        return this;
    }

    @Override
    public void setTargetAmount(UUID targetId, int amount, Game game) {
        this.targets.put(targetId, amount);
        this.rememberZoneChangeCounter(targetId, game);
        this.chosen = this.isChosen(game);
    }

    @Override
    public Target withChooseHint(String chooseHint) {
        this.chooseHint = chooseHint;
        return this;
    }

    @Override
    public String getChooseHint() {
        return this.chooseHint;
    }

    @Override
    public void setEventReporting(boolean shouldReport) {
        this.shouldReportEvents = shouldReport;
    }

    @Override
    public int getSize() {
        return this.targets.size();
    }

    @Override
    public boolean contains(UUID targetId) {
        return this.targets.containsKey(targetId);
    }

    @Override
    public UUID tryToAutoChoose(UUID abilityControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = this.possibleTargets(abilityControllerId, source, game);
        possibleTargets.removeAll(this.targets.keySet());
        return this.tryToAutoChoose(abilityControllerId, source, game, possibleTargets);
    }

    @Override
    public UUID tryToAutoChoose(UUID abilityControllerId, Ability source, Game game, Collection<UUID> possibleTargets) {
        boolean canAutoChoose;
        if (possibleTargets == null || game == null || source == null) {
            return null;
        }
        Player player = game.getPlayer(abilityControllerId);
        if (player == null) {
            return null;
        }
        int playerAutoTargetLevel = player.isHuman() && player.getControllingPlayersUserData(game) != null ? player.getControllingPlayersUserData(game).getAutoTargetLevel() : 2;
        boolean isOnline = player.canRespond();
        if (!player.isGameUnderControl()) {
            Player controllingPlayer = game.getPlayer(player.getTurnControlledBy());
            if (player.isHuman()) {
                isOnline = controllingPlayer.canRespond();
            }
        }
        String abilityText = source.getRule(true).toLowerCase();
        boolean strictModeEnabled = player.getStrictChooseMode();
        boolean bl = canAutoChoose = this.getMinNumberOfTargets() == this.getMaxNumberOfTargets() && isOnline && possibleTargets.size() == this.getMinNumberOfTargets() - this.getSize() && !strictModeEnabled && playerAutoTargetLevel > 0 && !abilityText.contains("search");
        if (canAutoChoose) {
            boolean autoTargetAll = playerAutoTargetLevel == 2;
            for (UUID possibleChooseId : possibleTargets) {
                boolean targetingOwnThing;
                if (this.targets.containsKey(possibleChooseId)) continue;
                if (autoTargetAll) {
                    return possibleChooseId;
                }
                if (possibleChooseId == abilityControllerId) {
                    targetingOwnThing = true;
                } else {
                    Permanent targetPermanent = game.getPermanent(possibleChooseId);
                    Card targetCard = game.getCard(possibleChooseId);
                    Spell targetSpell = game.getSpell(possibleChooseId);
                    if (targetPermanent != null) {
                        targetingOwnThing = abilityControllerId == targetPermanent.getControllerId();
                    } else if (targetCard != null) {
                        targetingOwnThing = abilityControllerId == targetCard.getOwnerId();
                    } else {
                        if (targetSpell == null) continue;
                        boolean bl2 = targetingOwnThing = abilityControllerId == targetSpell.getControllerId();
                    }
                }
                if (targetingOwnThing && (abilityText.contains("discard") || abilityText.contains("sacrifice") || abilityText.contains("destroy") || abilityText.contains("exile"))) continue;
                return possibleChooseId;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", from " + this.getMinNumberOfTargets() + " to " + this.getMaxNumberOfTargets() + ", " + this.getDescription() + ", selected " + this.getTargets().size();
    }
}

