/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterSource;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetObject;

public class TargetSource
extends TargetObject {
    protected final FilterSource filter;

    public TargetSource() {
        this(1, 1, new FilterSource("source of your choice"));
    }

    public TargetSource(FilterSource filter) {
        this(1, 1, filter);
    }

    public TargetSource(int numTargets, FilterSource filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetSource(int minNumTargets, int maxNumTargets, FilterSource filter) {
        super(minNumTargets, maxNumTargets, Zone.ALL, true);
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    protected TargetSource(TargetSource target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public FilterSource getFilter() {
        return this.filter;
    }

    @Override
    public void add(UUID id, Game game) {
        this.addTarget(id, null, game);
    }

    @Override
    public void addTarget(UUID id, Ability source, Game game) {
        if (this.targets.size() < this.maxNumberOfTargets) {
            MageObject object = game.getObject(id);
            if (object instanceof StackObject) {
                this.addTarget(((StackObject)object).getSourceId(), source, game, this.notTarget);
            } else {
                this.addTarget(id, source, game, this.notTarget);
            }
            if (object != null && !game.isSimulation()) {
                game.informPlayers("Selected " + object.getLogName() + " as source");
            }
        }
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (StackObject stackObject : game.getStack()) {
            if (!game.getState().getPlayersInRange(sourceControllerId, game).contains(stackObject.getControllerId()) || !this.filter.match(stackObject, sourceControllerId, source, game)) continue;
            possibleTargets.add(stackObject.getId());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, source, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        for (Player player : game.getPlayers().values()) {
            for (Card card : player.getGraveyard().getCards(game)) {
                if (!this.filter.match(card, sourceControllerId, source, game)) continue;
                possibleTargets.add(card.getId());
            }
        }
        for (Card card : game.getExile().getCardsInRange(game, sourceControllerId)) {
            if (!this.filter.match(card, sourceControllerId, source, game)) continue;
            possibleTargets.add(card.getId());
        }
        for (CommandObject commandObject : game.getState().getCommand()) {
            if (!this.filter.match(commandObject, sourceControllerId, source, game)) continue;
            possibleTargets.add(commandObject.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetSource copy() {
        return new TargetSource(this);
    }
}

