/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.util.Copyable;
import mage.util.DebugUtil;

public class Targets
extends ArrayList<Target>
implements Copyable<Targets> {
    private boolean isReadOnly = false;

    public Targets() {
    }

    public Targets(Target ... targets) {
        this.addAll((Collection<? extends Target>)Arrays.asList(targets));
    }

    protected Targets(Targets targets) {
        this.ensureCapacity(targets.size());
        for (Target target : targets) {
            this.add(target.copy());
        }
        this.isReadOnly = targets.isReadOnly;
    }

    public Targets withReadOnly() {
        this.isReadOnly = true;
        return this;
    }

    public Target getByTag(int tag) {
        return this.stream().filter(t -> t.getTargetTag() == tag).findFirst().orElse(null);
    }

    public List<UUID> getTargetsByTag(int tag) {
        Target target = this.getByTag(tag);
        if (target == null) {
            return new ArrayList<UUID>();
        }
        return target.getTargets();
    }

    public Target getNextUnchosen(Game game) {
        return this.getNextUnchosen(game, 0);
    }

    public Target getNextUnchosen(Game game, int unchosenIndex) {
        List res = this.stream().filter(target -> !target.isChoiceSelected()).collect(Collectors.toList());
        return unchosenIndex < res.size() ? (Target)res.get(unchosenIndex) : null;
    }

    public boolean isChoiceCompleted(UUID abilityControllerId, Ability source, Game game, Cards fromCards) {
        return this.stream().allMatch(t -> t.isChoiceCompleted(abilityControllerId, source, game, fromCards));
    }

    public void clearChosen() {
        for (Target target : this) {
            target.clearChosen();
        }
    }

    public boolean isChosen(Game game) {
        return this.stream().allMatch(t -> t.isChosen(game));
    }

    public boolean choose(Outcome outcome, UUID playerId, UUID sourceId, Ability source, Game game) {
        return this.makeChoice(false, outcome, playerId, source, false, game, false);
    }

    public boolean chooseTargets(Outcome outcome, UUID playerId, Ability source, boolean noMana, Game game, boolean canCancel) {
        return this.makeChoice(true, outcome, playerId, source, noMana, game, canCancel);
    }

    private boolean makeChoice(boolean isTargetChoice, Outcome outcome, UUID playerId, Ability source, boolean noMana, Game game, boolean canCancel) {
        for (Target target : this) {
            boolean choiceRes;
            UUID abilityControllerId = target.getAffectedAbilityControllerId(playerId);
            Player player = game.getPlayer(abilityControllerId);
            if (player == null || !player.canRespond()) {
                return false;
            }
            if (target.isChoiceSelected() || !target.canChoose(abilityControllerId, source, game)) continue;
            if (noMana) {
                target.setRequired(true);
            }
            if (canCancel) {
                target.setRequired(false);
            }
            if (choiceRes = isTargetChoice ? target.chooseTarget(outcome, abilityControllerId, source, game) : target.choose(outcome, abilityControllerId, source, game)) continue;
        }
        if (isTargetChoice && this.isChosen(game) && game.replaceEvent(new GameEvent(GameEvent.EventType.TARGETS_VALID, source.getSourceId(), source, source.getControllerId()), source)) {
            this.clearChosen();
        }
        if (DebugUtil.GAME_SHOW_CHOOSE_TARGET_LOGS && !game.isSimulation()) {
            Targets.printDebugTargets(isTargetChoice ? "target finish" : "choose finish", this, source, game);
        }
        return this.isChosen(game);
    }

    public static void printDebugTargets(String name, Targets targets, Ability source, Game game) {
        ArrayList<String> output = new ArrayList<String>();
        Targets.printDebugTargets(name, targets, source, game, output);
        output.forEach(System.out::println);
    }

    public static void printDebugTargets(String name, Targets targets, Ability source, Game game, List<String> output) {
        output.add("");
        output.add(name + ":");
        output.add(String.format("* chosen: %s", targets.isChosen(game) ? "yes" : "no"));
        output.add(String.format("* ability: %s", source));
        for (int i = 0; i < targets.size(); ++i) {
            Target target = (Target)targets.get(i);
            output.add(String.format("* target %d: %s", i + 1, target));
            if (target.getTargets().isEmpty()) {
                output.add("  - no choices");
                continue;
            }
            for (int j = 0; j < target.getTargets().size(); ++j) {
                MageObject targetObject;
                UUID targetId = target.getTargets().get(j);
                Player targetPlayer = game.getPlayer(targetId);
                String targetInfo = targetPlayer != null ? targetPlayer.toString() : ((targetObject = game.getObject(targetId)) != null ? targetObject.toString() : "unknown " + targetId);
                if (target instanceof TargetAmount) {
                    output.add(String.format("  - choice %d.%d: amount %d, %s", i + 1, j + 1, target.getTargetAmount(targetId), targetInfo));
                    continue;
                }
                output.add(String.format("  - choice %d.%d: %s", i + 1, j + 1, targetInfo));
            }
        }
    }

    public boolean stillLegal(Ability source, Game game) {
        int illegalCount = (int)this.stream().filter(target -> !target.isLegal(source, game)).count();
        return this.isEmpty() || this.size() != illegalCount;
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.stream().allMatch(target -> target.canChoose(sourceControllerId, source, game));
    }

    public boolean canChoose(UUID sourceControllerId, Game game) {
        return this.stream().allMatch(target -> target.canChoose(sourceControllerId, game));
    }

    public UUID getFirstTarget() {
        if (this.size() > 0) {
            return ((Target)this.get(0)).getFirstTarget();
        }
        return null;
    }

    @Override
    public Targets copy() {
        return new Targets(this);
    }

    private void checkReadOnlyModification() {
        if (this.isReadOnly) {
            throw new IllegalArgumentException("Wrong code usage: you can't modify read only targets list, e.g. from composite costs");
        }
    }

    @Override
    public boolean add(Target target) {
        this.checkReadOnlyModification();
        return super.add(target);
    }

    @Override
    public void add(int index, Target element) {
        this.checkReadOnlyModification();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Target> c) {
        this.checkReadOnlyModification();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Target> c) {
        this.checkReadOnlyModification();
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        this.checkReadOnlyModification();
        super.clear();
    }
}

