/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInCommandZone
extends TargetCard {
    public TargetCardInCommandZone(FilterCard filter) {
        super(1, 1, Zone.COMMAND, filter);
    }

    protected TargetCardInCommandZone(TargetCardInCommandZone targetCardInCommandZone) {
        super(targetCardInCommandZone);
    }

    @Override
    public TargetCardInCommandZone copy() {
        return new TargetCardInCommandZone(this);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        return game.getState().getZone(id) == Zone.COMMAND && game.getState().getPlayersInRange(this.getTargetController() == null ? playerId : this.getTargetController(), game).contains(game.getOwnerId(id)) && this.filter.match(card, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return this.canTarget(source == null ? null : source.getControllerId(), id, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        if (player == null) {
            return possibleTargets;
        }
        CardsImpl cards = new CardsImpl(game.getCommanderCardsFromCommandZone(player, CommanderCardType.ANY));
        for (Card card : cards.getCards(this.filter, sourceControllerId, source, game)) {
            possibleTargets.add(card.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }
}

