/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInLibrary
extends TargetCard {
    private int librarySearchLimit;

    public TargetCardInLibrary() {
        this(1, 1, StaticFilters.FILTER_CARD);
    }

    public TargetCardInLibrary(FilterCard filter) {
        this(1, 1, filter);
    }

    public TargetCardInLibrary(int numTargets, FilterCard filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetCardInLibrary(int minNumTargets, int maxNumTargets, FilterCard filter) {
        super(minNumTargets, maxNumTargets, Zone.LIBRARY, filter);
        this.setRequired(!filter.hasPredicates());
        this.withNotTarget(true);
        this.librarySearchLimit = Integer.MAX_VALUE;
    }

    protected TargetCardInLibrary(TargetCardInLibrary target) {
        super(target);
        this.librarySearchLimit = target.librarySearchLimit;
    }

    @Override
    public boolean choose(Outcome outcome, UUID playerId, UUID targetPlayerId, Ability source, Game game) {
        int prevTargetsCount;
        Player player = game.getPlayer(playerId);
        Player targetPlayer = game.getPlayer(targetPlayerId);
        if (targetPlayer == null) {
            targetPlayer = player;
        }
        if (player == null) {
            return false;
        }
        List<Card> cards = this.librarySearchLimit == Integer.MAX_VALUE ? targetPlayer.getLibrary().getCards(game) : new ArrayList<Card>(targetPlayer.getLibrary().getTopCards(game, this.librarySearchLimit));
        cards.sort(Comparator.comparing(MageObject::getName));
        CardsImpl cardsId = new CardsImpl();
        cards.forEach(cardsId::add);
        UUID abilityControllerId = this.getAffectedAbilityControllerId(playerId);
        this.chosen = false;
        do {
            prevTargetsCount = this.getTargets().size();
            if (!player.canRespond()) break;
            if (!player.chooseTarget(outcome, cardsId, this, source, game)) {
                return this.chosen;
            }
            this.chosen = this.isChosen(game);
        } while (!this.isChoiceCompleted(abilityControllerId, source, game, null) && prevTargetsCount != this.getTargets().size());
        this.chosen = this.isChosen(game);
        return this.getTargets().size() > 0;
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Card card = game.getPlayer(source.getControllerId()).getLibrary().getCard(id, game);
        return this.filter.match(card, source.getControllerId(), source, game);
    }

    @Override
    public TargetCardInLibrary copy() {
        return new TargetCardInLibrary(this);
    }

    @Override
    public void setMinNumberOfTargets(int minNumberOfTargets) {
        this.minNumberOfTargets = minNumberOfTargets;
    }

    public void setCardLimit(int librarySearchLimit) {
        this.librarySearchLimit = librarySearchLimit;
    }
}

