/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInYourGraveyardOrExile
extends TargetCard {
    private final FilterCard filterGraveyard;
    private final FilterCard filterExile;

    public TargetCardInYourGraveyardOrExile(FilterCard filterGraveyard, FilterCard filterExile) {
        super(1, 1, Zone.GRAVEYARD, filterGraveyard);
        this.filterGraveyard = filterGraveyard;
        this.filterExile = filterExile;
        this.targetName = filterGraveyard.getMessage() + " or " + filterExile.getMessage();
    }

    protected TargetCardInYourGraveyardOrExile(TargetCardInYourGraveyardOrExile target) {
        super(target);
        this.filterGraveyard = target.filterGraveyard;
        this.filterExile = target.filterExile;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        if (player == null) {
            return possibleTargets;
        }
        possibleTargets.addAll(TargetCardInYourGraveyardOrExile.getAllPossibleTargetInGraveyard(game, player, sourceControllerId, source, this.filterGraveyard, this.isNotTarget()));
        possibleTargets.addAll(TargetCardInYourGraveyardOrExile.getAllPossibleTargetInExile(game, player, sourceControllerId, source, this.filterExile, this.isNotTarget()));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return this.canTarget(source == null ? null : source.getControllerId(), id, source, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        switch (game.getState().getZone(id)) {
            case GRAVEYARD: {
                return playerId == null ? this.filterGraveyard.match(card, game) : this.filterGraveyard.match(card, playerId, source, game);
            }
            case EXILED: {
                return playerId == null ? this.filterExile.match(card, game) : this.filterExile.match(card, playerId, source, game);
            }
        }
        return false;
    }

    @Override
    public TargetCardInYourGraveyardOrExile copy() {
        return new TargetCardInYourGraveyardOrExile(this);
    }
}

