/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

public class TargetCardWithDifferentNameInLibrary
extends TargetCardInLibrary {
    public TargetCardWithDifferentNameInLibrary(int minNumTargets, int maxNumTargets, FilterCard filter) {
        super(minNumTargets, maxNumTargets, filter);
    }

    protected TargetCardWithDifferentNameInLibrary(TargetCardWithDifferentNameInLibrary target) {
        super(target);
    }

    @Override
    public TargetCardWithDifferentNameInLibrary copy() {
        return new TargetCardWithDifferentNameInLibrary(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) return false;
        if (!this.getTargets().stream().map(game::getCard).noneMatch(c -> CardUtil.haveSameNames(c, card))) return false;
        return true;
    }
}

