/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.filter.Filter;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetAmount;

public abstract class TargetPermanentOrPlayerAmount
extends TargetAmount {
    protected FilterPermanentOrPlayer filter;

    TargetPermanentOrPlayerAmount(DynamicValue amount, int minNumberOfTargets, int maxNumberOfTargets) {
        super(amount, minNumberOfTargets, maxNumberOfTargets);
    }

    TargetPermanentOrPlayerAmount(TargetPermanentOrPlayerAmount target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public boolean canTarget(UUID objectId, Ability source, Game game) {
        Permanent permanent = game.getPermanent(objectId);
        Player player = game.getPlayer(objectId);
        if (source != null) {
            if (permanent != null) {
                return (this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(permanent, source.getControllerId(), source, game);
            }
            if (player != null) {
                return (this.isNotTarget() || player.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(player, game);
            }
        } else {
            if (permanent != null) {
                return this.filter.match(permanent, game);
            }
            if (player != null) {
                return this.filter.match(player, game);
            }
        }
        return false;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID objectId, Ability source, Game game) {
        return this.canTarget(objectId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        game.getState().getPlayersInRange(sourceControllerId, game).stream().map(game::getPlayer).filter(Objects::nonNull).filter(player -> this.filter.match((MageItem)player, game)).map(MageItem::getId).forEach(possibleTargets::add);
        game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game).stream().filter(Objects::nonNull).map(MageItem::getId).forEach(possibleTargets::add);
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent != null) {
                sb.append(permanent.getLogName()).append(" (").append(this.getTargetAmount(targetId)).append(") ");
                continue;
            }
            Player player = game.getPlayer(targetId);
            if (player == null) continue;
            sb.append(player.getLogName()).append(" (").append(this.getTargetAmount(targetId)).append(") ");
        }
        return sb.toString().trim();
    }
}

