/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

public class TargetPermanentSameController
extends TargetPermanent {
    public TargetPermanentSameController(FilterPermanent filter) {
        this(2, filter);
    }

    public TargetPermanentSameController(int numTargets, FilterPermanent filter) {
        super(numTargets, numTargets, filter, false);
    }

    protected TargetPermanentSameController(TargetPermanentSameController target) {
        super(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Permanent firstTargetPermanent = game.getPermanent(id);
        if (firstTargetPermanent == null) return false;
        if (!this.getTargets().stream().map(game::getPermanent).filter(Objects::nonNull).filter(permanent -> !permanent.equals(firstTargetPermanent)).map(Controllable::getControllerId).allMatch(firstTargetPermanent::isControlledBy)) return false;
        return true;
    }

    @Override
    public TargetPermanentSameController copy() {
        return new TargetPermanentSameController(this);
    }
}

