/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetpointer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.Targets;
import mage.target.targetpointer.TargetPointerImpl;
import mage.util.CardUtil;

public class EachTargetPointer
extends TargetPointerImpl {
    private final Map<UUID, Integer> zoneChangeCounter = new HashMap<UUID, Integer>();

    public EachTargetPointer() {
    }

    protected EachTargetPointer(EachTargetPointer targetPointer) {
        super(targetPointer);
        this.zoneChangeCounter.putAll(targetPointer.zoneChangeCounter);
    }

    @Override
    public void init(Game game, Ability source) {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized();
        if (!source.getTargets().isEmpty()) {
            for (UUID target : source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toList())) {
                Card card = game.getCard(target);
                if (card == null) continue;
                this.zoneChangeCounter.put(target, card.getZoneChangeCounter(game));
            }
        }
    }

    @Override
    public List<UUID> getTargets(Game game, Ability source) {
        ArrayList<UUID> target = new ArrayList<UUID>();
        if (!source.getTargets().isEmpty()) {
            for (UUID targetId : source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toList())) {
                Permanent permanent;
                Card card = game.getCard(targetId);
                if (card != null && this.zoneChangeCounter.containsKey(targetId) && card.getZoneChangeCounter(game) != this.zoneChangeCounter.get(targetId).intValue() && ((permanent = game.getPermanentOrLKIBattlefield(targetId)) == null || permanent.getZoneChangeCounter(game) != this.zoneChangeCounter.get(targetId).intValue())) continue;
                target.add(targetId);
            }
        }
        return target;
    }

    @Override
    public UUID getFirst(Game game, Ability source) {
        Permanent permanent;
        Card card;
        UUID targetId = source.getFirstTarget();
        if (this.zoneChangeCounter.containsKey(targetId) && (card = game.getCard(targetId)) != null && this.zoneChangeCounter.containsKey(targetId) && card.getZoneChangeCounter(game) != this.zoneChangeCounter.get(targetId).intValue() && ((permanent = game.getPermanentOrLKIBattlefield(targetId)) == null || permanent.getZoneChangeCounter(game) != this.zoneChangeCounter.get(targetId).intValue())) {
            return null;
        }
        return targetId;
    }

    @Override
    public EachTargetPointer copy() {
        return new EachTargetPointer(this);
    }

    @Override
    public Permanent getFirstTargetPermanentOrLKI(Game game, Ability source) {
        Permanent permanent;
        UUID targetId = source.getFirstTarget();
        if (this.zoneChangeCounter.containsKey(targetId)) {
            permanent = game.getPermanent(targetId);
            if (permanent != null && permanent.getZoneChangeCounter(game) == this.zoneChangeCounter.get(targetId).intValue()) {
                return permanent;
            }
            MageObject mageObject = game.getLastKnownInformation(targetId, Zone.BATTLEFIELD, this.zoneChangeCounter.get(targetId));
            if (mageObject instanceof Permanent) {
                return (Permanent)mageObject;
            }
        } else {
            permanent = game.getPermanent(targetId);
            if (permanent == null) {
                permanent = (Permanent)game.getLastKnownInformation(targetId, Zone.BATTLEFIELD);
            }
        }
        return permanent;
    }

    @Override
    public String describeTargets(Targets targets, String defaultDescription) {
        if (this.targetDescription != null) {
            return this.targetDescription;
        }
        if (targets.isEmpty()) {
            return defaultDescription;
        }
        return CardUtil.concatWithAnd(targets.stream().map(Target::getDescription).collect(Collectors.toList()));
    }

    @Override
    public boolean isPlural(Targets targets) {
        return true;
    }
}

