/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetpointer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.TargetPointerImpl;

public class FixedTargets
extends TargetPointerImpl {
    final ArrayList<MageObjectReference> targets = new ArrayList();

    public FixedTargets(Collection<? extends Card> objects, Game game) {
        this(objects.stream().map(o -> new MageObjectReference(o.getId(), game)).collect(Collectors.toList()));
    }

    public FixedTargets(Cards objects, Game game) {
        this(objects.getCards(game).stream().map(o -> new MageObjectReference(o.getId(), game)).collect(Collectors.toList()));
    }

    public FixedTargets(Token token, Game game) {
        this(token.getLastAddedTokenIds().stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toList()), game);
    }

    public FixedTargets(Collection<MageObjectReference> morList) {
        this.targets.addAll(morList);
        this.setInitialized();
    }

    private FixedTargets(FixedTargets pointer) {
        super(pointer);
        this.targets.addAll(pointer.targets);
    }

    @Override
    public void init(Game game, Ability source) {
        if (this.isInitialized()) {
            return;
        }
        throw new IllegalArgumentException("Wrong code usage: FixedTargets support only static ZCC, you can't get here");
    }

    @Override
    public List<UUID> getTargets(Game game, Ability source) {
        return this.targets.stream().filter(mor -> mor.zoneCounterIsCurrent(game)).map(MageObjectReference::getSourceId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public UUID getFirst(Game game, Ability source) {
        return this.targets.stream().filter(mor -> mor.zoneCounterIsCurrent(game)).map(MageObjectReference::getSourceId).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public FixedTargets copy() {
        return new FixedTargets(this);
    }

    @Override
    public Permanent getFirstTargetPermanentOrLKI(Game game, Ability source) {
        UUID targetId = null;
        int zoneChangeCounter = Integer.MIN_VALUE;
        if (!this.targets.isEmpty()) {
            MageObjectReference mor = this.targets.get(0);
            targetId = mor.getSourceId();
            zoneChangeCounter = mor.getZoneChangeCounter();
        }
        if (targetId != null) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent != null && (zoneChangeCounter == Integer.MIN_VALUE || permanent.getZoneChangeCounter(game) == zoneChangeCounter)) {
                return permanent;
            }
            MageObject mageObject = zoneChangeCounter == Integer.MIN_VALUE ? game.getLastKnownInformation(targetId, Zone.BATTLEFIELD) : game.getLastKnownInformation(targetId, Zone.BATTLEFIELD, zoneChangeCounter);
            if (mageObject instanceof Permanent) {
                return (Permanent)mageObject;
            }
        }
        return null;
    }
}

