/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.Set;
import mage.cards.Card;

public final class DeckBuildUtils {
    public static int[] landCountSuggestion(int deckSize, Set<Card> deckList) {
        int plains = 0;
        int islands = 0;
        int swamps = 0;
        int mountains = 0;
        int forests = 0;
        int landsNeeded = deckSize - deckList.size();
        if (landsNeeded > 0) {
            int white = 0;
            int blue = 0;
            int black = 0;
            int red = 0;
            int green = 0;
            for (Card cd : deckList) {
                for (String s : cd.getManaCostSymbols()) {
                    if (s.contains("W")) {
                        ++white;
                    }
                    if (s.contains("U")) {
                        ++blue;
                    }
                    if (s.contains("B")) {
                        ++black;
                    }
                    if (s.contains("R")) {
                        ++red;
                    }
                    if (!s.contains("G")) continue;
                    ++green;
                }
            }
            int total = white + blue + black + red + green;
            if (total == 0) {
                total = 5;
                white = 1;
                blue = 1;
                black = 1;
                red = 1;
            }
            plains = Math.round((float)landsNeeded * ((float)white / (float)total));
            islands = Math.round((float)(landsNeeded -= plains) * ((float)blue / (float)(total -= white)));
            swamps = Math.round((float)(landsNeeded -= islands) * ((float)black / (float)(total -= blue)));
            mountains = Math.round((float)(landsNeeded -= swamps) * ((float)red / (float)(total -= black)));
            forests = landsNeeded -= mountains;
        }
        return new int[]{plains, islands, swamps, mountains, forests};
    }
}

