/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mage.cards.Card;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.constants.Rarity;
import mage.util.RandomUtil;

public final class TournamentUtil {
    public static Set<String> getLandSetCodeForDeckSets(Collection<String> setCodesDeck) {
        List basicLandSets;
        ExpansionInfo expansionInfo;
        HashSet<String> landSetCodes = new HashSet<String>();
        for (String setCode : setCodesDeck) {
            expansionInfo = ExpansionRepository.instance.getSetByCode(setCode);
            if (!expansionInfo.hasBasicLands() || CardRepository.haveSnowLands(setCode).booleanValue()) continue;
            landSetCodes.add(expansionInfo.getCode());
        }
        if (landSetCodes.isEmpty()) {
            for (String setCode : setCodesDeck) {
                expansionInfo = ExpansionRepository.instance.getSetByCode(setCode);
                List<ExpansionInfo> blockSets = ExpansionRepository.instance.getSetsFromBlock(expansionInfo.getBlockName());
                for (ExpansionInfo blockSet : blockSets) {
                    if (!blockSet.hasBasicLands() || CardRepository.haveSnowLands(blockSet.getCode()).booleanValue()) continue;
                    landSetCodes.add(blockSet.getCode());
                }
            }
        }
        if (landSetCodes.isEmpty() && !(basicLandSets = ExpansionRepository.instance.getSetsWithBasicLandsByReleaseDate().stream().filter(exp -> CardRepository.haveSnowLands(exp.getCode()) == false).collect(Collectors.toList())).isEmpty()) {
            landSetCodes.add(((ExpansionInfo)basicLandSets.get(RandomUtil.nextInt(basicLandSets.size()))).getCode());
        }
        if (landSetCodes.isEmpty()) {
            throw new IllegalArgumentException("No set with basic land was found (possible memory problems, need server restart)");
        }
        return landSetCodes;
    }

    public static List<Card> getLands(String landName, int number, Set<String> landSets) {
        CardCriteria criteria = new CardCriteria();
        if (!landSets.isEmpty()) {
            criteria.setCodes(landSets.toArray(new String[landSets.size()]));
        } else {
            criteria.ignoreSetsWithSnowLands();
        }
        criteria.rarities(Rarity.LAND).name(landName);
        List<CardInfo> lands = CardRepository.instance.findCards(criteria);
        ArrayList<Card> cards = new ArrayList<Card>();
        if (!lands.isEmpty()) {
            for (int i = 0; i < number; ++i) {
                Card land = lands.get(RandomUtil.nextInt(lands.size())).createCard();
                cards.add(land);
            }
        }
        return cards;
    }
}

