/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class AmountOfDamageAPlayerReceivedThisTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfDamageReceivedThisTurn = new HashMap<UUID, Integer>();

    public AmountOfDamageAPlayerReceivedThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && (playerId = event.getTargetId()) != null) {
            this.amountOfDamageReceivedThisTurn.putIfAbsent(playerId, 0);
            this.amountOfDamageReceivedThisTurn.compute(playerId, (k, v) -> v + event.getAmount());
        }
    }

    public int getAmountOfDamageReceivedThisTurn(UUID playerId) {
        return this.amountOfDamageReceivedThisTurn.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfDamageReceivedThisTurn.clear();
    }
}

