/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mage.constants.CommanderCardType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class CommanderPlaysCountWatcher
extends Watcher {
    private final Map<UUID, Integer> playsCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> playerCount = new HashMap<UUID, Integer>();

    public CommanderPlaysCountWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.LAND_PLAYED && event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        UUID objectId = event.getType() == GameEvent.EventType.LAND_PLAYED ? CardUtil.getMainCardId(game, event.getTargetId()) : (event.getType() == GameEvent.EventType.SPELL_CAST ? CardUtil.getMainCardId(game, event.getSourceId()) : null);
        boolean isCommanderObject = game.getPlayerList().stream().map(game::getPlayer).map(player -> game.getCommandersIds((Player)player, CommanderCardType.ANY, false)).flatMap(Collection::stream).anyMatch(id -> Objects.equals(id, objectId));
        if (!isCommanderObject || event.getZone() != Zone.COMMAND) {
            return;
        }
        this.playsCount.putIfAbsent(objectId, 0);
        this.playsCount.computeIfPresent(objectId, (u, i) -> i + 1);
        this.playerCount.putIfAbsent(event.getPlayerId(), 0);
        this.playerCount.compute(event.getPlayerId(), (u, i) -> i + 1);
    }

    public int getPlaysCount(UUID commanderId) {
        return this.playsCount.getOrDefault(commanderId, 0);
    }

    public int getPlayerCount(UUID playerId) {
        return this.playerCount.getOrDefault(playerId, 0);
    }
}

