/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class ControlledModifiedCreatureAsSpellCastWatcher
extends Watcher {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private final HashMap<MageObjectReference, Integer> modifiedCreaturesWhenCast = new HashMap();

    public ControlledModifiedCreatureAsSpellCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getSpell(event.getTargetId())) != null) {
            MageObjectReference mor = new MageObjectReference(spell, game);
            this.modifiedCreaturesWhenCast.put(mor, game.getBattlefield().countAll(filter, spell.getControllerId(), game));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.modifiedCreaturesWhenCast.clear();
    }

    public int getModifiedCreatureCount(MageObjectReference mor) {
        return this.modifiedCreaturesWhenCast.getOrDefault(mor, 0);
    }

    static {
        filter.add(ModifiedPredicate.instance);
    }
}

