/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

public class CreatureEnteredControllerWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public CreatureEnteredControllerWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.BATTLEFIELD && zEvent.getTarget().isCreature(game)) {
            this.players.add(zEvent.getTarget().getControllerId());
        }
    }

    @Override
    public void reset() {
        this.players.clear();
    }

    public static boolean enteredCreatureForPlayer(UUID playerId, Game game) {
        return game.getState().getWatcher(CreatureEnteredControllerWatcher.class).players.contains(playerId);
    }
}

