/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class CreaturesDiedWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCreaturesThatDiedByController = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> amountOfCreaturesThatDiedByOwner = new HashMap<UUID, Integer>();

    public CreaturesDiedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || zEvent.getTarget() == null || !zEvent.getTarget().isCreature(game)) {
            return;
        }
        this.condition = true;
        this.amountOfCreaturesThatDiedByController.compute(zEvent.getTarget().getControllerId(), CardUtil::setOrIncrementValue);
        this.amountOfCreaturesThatDiedByOwner.compute(zEvent.getTarget().getOwnerId(), CardUtil::setOrIncrementValue);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfCreaturesThatDiedByController.clear();
        this.amountOfCreaturesThatDiedByOwner.clear();
    }

    public int getAmountOfCreaturesDiedThisTurnByController(UUID playerId) {
        return this.amountOfCreaturesThatDiedByController.getOrDefault(playerId, 0);
    }

    public int getAmountOfCreaturesDiedThisTurnByOwner(UUID playerId) {
        return this.amountOfCreaturesThatDiedByOwner.getOrDefault(playerId, 0);
    }

    public int getAmountOfCreaturesDiedThisTurn() {
        return this.amountOfCreaturesThatDiedByController.values().stream().mapToInt(x -> x).sum();
    }
}

