/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.common.RevealDragonFromHandCost;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class DragonOnTheBattlefieldWhileSpellWasCastWatcher
extends Watcher {
    private final Set<MageObjectReference> castWithDragonOnTheBattlefield = new HashSet<MageObjectReference>();

    public DragonOnTheBattlefieldWhileSpellWasCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null) {
            if (spell.getSpellAbility().getCosts().stream().filter(RevealDragonFromHandCost.class::isInstance).map(RevealDragonFromHandCost.class::cast).anyMatch(RevealDragonFromHandCost::isRevealedOrControlled)) {
                this.castWithDragonOnTheBattlefield.add(new MageObjectReference(spell.getCard(), game, 0));
                this.castWithDragonOnTheBattlefield.add(new MageObjectReference(spell.getCard(), game, 1));
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.castWithDragonOnTheBattlefield.clear();
    }

    public boolean checkCondition(Ability source, Game game) {
        return this.castWithDragonOnTheBattlefield.stream().anyMatch(mor -> mor.refersTo(source.getSourceObject(game), game));
    }
}

