/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class LandfallWatcher
extends Watcher {
    private final Set<UUID> playerPlayedLand = new HashSet<UUID>();
    private final Set<UUID> landEnteredBattlefield = new HashSet<UUID>();

    public LandfallWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && permanent.isLand(game) && !this.playerPlayedLand.contains(event.getPlayerId())) {
            this.playerPlayedLand.add(event.getPlayerId());
            this.landEnteredBattlefield.add(event.getTargetId());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerPlayedLand.clear();
        this.landEnteredBattlefield.clear();
    }

    public boolean landPlayed(UUID playerId) {
        return this.playerPlayedLand.contains(playerId);
    }

    public boolean landEnteredBattlefield(UUID landId) {
        return this.landEnteredBattlefield.contains(landId);
    }
}

