/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class LifeLostThisTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> playersLostLife = new HashMap<UUID, Integer>();

    public LifeLostThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.LOST_LIFE_BATCH_FOR_ONE_PLAYER) {
            this.playersLostLife.compute(event.getTargetId(), CardUtil::setOrIncrementValue);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playersLostLife.clear();
    }

    public int timesLostLifeThisTurn(UUID playerId) {
        return this.playersLostLife.getOrDefault(playerId, 0);
    }
}

