/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.ObjectColor;
import mage.constants.ManaType;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaPaidEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.util.Copyable;
import mage.watchers.Watcher;

public class ManaPaidSourceWatcher
extends Watcher {
    private static final ManaPaidTracker emptyTracker = new ManaPaidTracker();
    private final Map<UUID, ManaPaidTracker> manaMap = new HashMap<UUID, ManaPaidTracker>();

    public ManaPaidSourceWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                if (((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD || ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD) {
                    this.manaMap.remove(event.getTargetId());
                }
                return;
            }
            case MANA_PAID: {
                ManaPaidEvent manaEvent = (ManaPaidEvent)event;
                this.manaMap.computeIfAbsent(manaEvent.getTargetId(), x -> new ManaPaidTracker()).increment(manaEvent.getSourceObject(), manaEvent.getManaType(), game);
                this.manaMap.computeIfAbsent(manaEvent.getSourcePaidId(), x -> new ManaPaidTracker()).increment(manaEvent.getSourceObject(), manaEvent.getManaType(), game);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.manaMap.clear();
    }

    public static int getTotalPaid(UUID sourceId, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).total;
    }

    public static int getTreasurePaid(UUID sourceId, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).treasure;
    }

    public static int getCreaturePaid(UUID sourceId, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).creature;
    }

    public static int getArtifactPaid(UUID sourceId, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).artifact;
    }

    public static int getSnowPaid(UUID sourceId, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, ManaPaidSourceWatcher.emptyTracker).getSnow();
    }

    public static boolean checkSnowColor(Spell spell, Game game) {
        ManaPaidSourceWatcher watcher = game.getState().getWatcher(ManaPaidSourceWatcher.class);
        return watcher != null && watcher.manaMap.getOrDefault(spell.getSpellAbility().getId(), ManaPaidSourceWatcher.emptyTracker).checkSnowColor(spell, game);
    }

    public void testsIncrementManaAmount(Game game, MageObject mageObject) {
        ((ManaPaidTracker)this.manaMap.getOrDefault(mageObject.getId(), null)).increment(mageObject, ManaType.RED, game);
    }

    public int testsReturnTotal(MageObject mageObject) {
        return ((ManaPaidTracker)this.manaMap.getOrDefault(mageObject.getId(), null)).total;
    }

    private static final class ManaPaidTracker
    implements Serializable,
    Copyable<ManaPaidTracker> {
        private int total = 0;
        private int whiteSnow = 0;
        private int blueSnow = 0;
        private int blackSnow = 0;
        private int redSnow = 0;
        private int greenSnow = 0;
        private int colorlessSnow = 0;
        private int treasure = 0;
        private int creature = 0;
        private int artifact = 0;

        private ManaPaidTracker() {
        }

        private ManaPaidTracker(ManaPaidTracker tracker) {
            this.total = tracker.total;
            this.whiteSnow = tracker.whiteSnow;
            this.blueSnow = tracker.blueSnow;
            this.blackSnow = tracker.blackSnow;
            this.redSnow = tracker.redSnow;
            this.greenSnow = tracker.greenSnow;
            this.colorlessSnow = tracker.colorlessSnow;
            this.treasure = tracker.treasure;
            this.creature = tracker.creature;
            this.artifact = tracker.artifact;
        }

        @Override
        public ManaPaidTracker copy() {
            return new ManaPaidTracker(this);
        }

        private void increment(MageObject sourceObject, ManaType manaType, Game game) {
            ++this.total;
            if (sourceObject != null && sourceObject.hasSubtype(SubType.TREASURE, game)) {
                ++this.treasure;
            }
            if (sourceObject != null && sourceObject.isCreature(game)) {
                ++this.creature;
            }
            if (sourceObject != null && sourceObject.isArtifact(game)) {
                ++this.artifact;
            }
            if (sourceObject != null && !sourceObject.isSnow(game)) {
                return;
            }
            switch (manaType) {
                case WHITE: {
                    ++this.whiteSnow;
                    break;
                }
                case BLUE: {
                    ++this.blueSnow;
                    break;
                }
                case BLACK: {
                    ++this.blackSnow;
                    break;
                }
                case RED: {
                    ++this.redSnow;
                    break;
                }
                case GREEN: {
                    ++this.greenSnow;
                    break;
                }
                case COLORLESS: 
                case GENERIC: {
                    ++this.colorlessSnow;
                }
            }
        }

        private int getSnow() {
            return this.whiteSnow + this.blueSnow + this.blackSnow + this.redSnow + this.greenSnow + this.colorlessSnow;
        }

        private boolean checkSnowColor(Spell spell, Game game) {
            ObjectColor color = spell.getColor(game);
            return color.isWhite() && this.whiteSnow > 0 || color.isBlue() && this.blueSnow > 0 || color.isBlack() && this.blackSnow > 0 || color.isRed() && this.redSnow > 0 || color.isGreen() && this.greenSnow > 0;
        }
    }
}

