/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.hint.Hint;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;
import mage.watchers.common.OnceEachTurnCastHint;

public class OnceEachTurnCastWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> usedFrom = new HashMap<UUID, Set<MageObjectReference>>();

    public OnceEachTurnCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.getPlayerId() != null && event.hasApprovingIdentifier(MageIdentifier.OnceEachTurnCastWatcher)) {
            this.usedFrom.computeIfAbsent(event.getPlayerId(), k -> new HashSet()).add(event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    public boolean isAbilityUsed(UUID playerId, MageObjectReference mor) {
        return this.usedFrom.getOrDefault(playerId, Collections.emptySet()).contains(mor);
    }

    public static Hint getHint() {
        return OnceEachTurnCastHint.instance;
    }
}

