/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class PermanentsSacrificedWatcher
extends Watcher {
    private final Map<UUID, List<Permanent>> sacrificedPermanents = new HashMap<UUID, List<Permanent>>();

    public PermanentsSacrificedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Permanent perm;
        if (event.getType() == GameEvent.EventType.SACRIFICED_PERMANENT && (perm = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null) {
            List<Object> permanents;
            if (!this.sacrificedPermanents.containsKey(perm.getControllerId())) {
                permanents = new ArrayList();
                this.sacrificedPermanents.put(perm.getControllerId(), permanents);
            } else {
                permanents = this.sacrificedPermanents.get(perm.getControllerId());
            }
            permanents.add(perm);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.sacrificedPermanents.clear();
    }

    public List<Permanent> getThisTurnSacrificedPermanents(UUID playerId) {
        return this.sacrificedPermanents.get(playerId);
    }

    public int getThisTurnSacrificedPermanents() {
        return this.sacrificedPermanents.values().stream().mapToInt(permanents -> permanents.size()).sum();
    }
}

