/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class PlayerAttackedWatcher
extends Watcher {
    private final Map<UUID, Integer> playerAttacked = new HashMap<UUID, Integer>();

    public PlayerAttackedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            this.playerAttacked.putIfAbsent(event.getPlayerId(), 0);
            this.playerAttacked.compute(event.getPlayerId(), (p, amount) -> amount + 1);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerAttacked.clear();
    }

    public int getNumberOfAttackersCurrentTurn(UUID playerId) {
        return this.playerAttacked.getOrDefault(playerId, 0);
    }
}

