/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class PlayerCastCreatureWatcher
extends Watcher {
    private final Set<UUID> playerIds = new HashSet<UUID>();

    public PlayerCastCreatureWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())).isCreature(game)) {
            this.playerIds.add(spell.getControllerId());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerIds.clear();
    }

    public boolean playerDidCastCreatureThisTurn(UUID playerId) {
        return this.playerIds.contains(playerId);
    }
}

