/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class SourceDidDamageWatcher
extends Watcher {
    private final Set<MageObjectReference> damageSources = new HashSet<MageObjectReference>();

    public SourceDidDamageWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER) {
            this.damageSources.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public boolean checkSource(MageObject mageObject, Game game) {
        return this.damageSources.stream().anyMatch(mor -> mor.refersTo(mageObject, game));
    }

    @Override
    public void reset() {
        super.reset();
        this.damageSources.clear();
    }
}

