/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class SpellsCastWatcher
extends Watcher {
    private final Map<UUID, List<Spell>> spellsCast = new HashMap<UUID, List<Spell>>();
    private final Map<UUID, List<Spell>> spellsCastFromGraveyard = new HashMap<UUID, List<Spell>>();
    private int nonCreatureSpells;

    public SpellsCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (GameEvent.EventType.SPELL_CAST == event.getType()) {
            MageObject mageObject;
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null && (mageObject = game.getLastKnownInformation(event.getTargetId(), Zone.STACK)) instanceof Spell) {
                spell = (Spell)mageObject;
            }
            if (spell != null) {
                List spells = this.spellsCast.computeIfAbsent(spell.getControllerId(), x -> new ArrayList());
                List graveyardSpells = this.spellsCastFromGraveyard.computeIfAbsent(spell.getControllerId(), x -> new ArrayList());
                spells.add(spell.copy());
                if (event.getZone() == Zone.GRAVEYARD) {
                    graveyardSpells.add(spell.copy());
                }
                if (StaticFilters.FILTER_SPELL_NON_CREATURE.match(spell, game)) {
                    ++this.nonCreatureSpells;
                }
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.nonCreatureSpells = 0;
        this.spellsCast.clear();
        this.spellsCastFromGraveyard.clear();
    }

    public Stream<Spell> getAllSpellsCastThisTurn() {
        return this.spellsCast.values().stream().flatMap(Collection::stream);
    }

    public List<Spell> getSpellsCastThisTurn(UUID playerId) {
        return this.spellsCast.computeIfAbsent(playerId, x -> new ArrayList());
    }

    public List<Spell> getSpellsCastFromGraveyardThisTurn(UUID playerId) {
        return this.spellsCastFromGraveyard.computeIfAbsent(playerId, x -> new ArrayList());
    }

    public int getNumberOfNonCreatureSpells() {
        return this.nonCreatureSpells;
    }

    public UUID getCasterId(Ability source, Game game) {
        for (Map.Entry<UUID, List<Spell>> entry : this.spellsCast.entrySet()) {
            if (!entry.getValue().stream().map(Spell::getCard).map(Card::getMainCard).anyMatch(card -> card.getId().equals(source.getSourceId()) && card.getZoneChangeCounter(game) == source.getStackMomentSourceZCC())) continue;
            return entry.getKey();
        }
        return null;
    }

    public int getCount(UUID playerId) {
        return this.spellsCast.getOrDefault(playerId, Collections.emptyList()).size();
    }
}

