/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.keyword.WarpAbility;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class VoidWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public VoidWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: {
                Spell spell = game.getSpell(event.getTargetId());
                if (spell != null && spell.getSpellAbility() instanceof WarpAbility) {
                    this.players.addAll(game.getState().getPlayersInRange(spell.getControllerId(), game));
                }
                return;
            }
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (!Zone.BATTLEFIELD.match(zEvent.getFromZone()) || zEvent.getTarget() == null || zEvent.getTarget().isLand(game)) break;
                this.players.addAll(game.getState().getPlayersInRange(zEvent.getTarget().getControllerId(), game));
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.players.clear();
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        return game.getState().getWatcher(VoidWatcher.class).players.contains(playerId);
    }
}

