/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.common.PassAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.SearchEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.ExaltedAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.ReachAbility;
import mage.cards.Cards;
import mage.choices.Choice;
import mage.constants.Outcome;
import mage.constants.RangeOfInfluence;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.player.ai.CombatEvaluator;
import mage.player.ai.ComputerPlayer;
import mage.player.ai.SimulatedPlayer2;
import mage.player.ai.SimulationNode2;
import mage.player.ai.ma.optimizers.TreeOptimizer;
import mage.player.ai.ma.optimizers.impl.DiscardCardOptimizer;
import mage.player.ai.ma.optimizers.impl.EquipOptimizer;
import mage.player.ai.ma.optimizers.impl.LevelUpOptimizer;
import mage.player.ai.ma.optimizers.impl.OutcomeOptimizer;
import mage.player.ai.ma.optimizers.impl.WrongCodeUsageOptimizer;
import mage.player.ai.score.GameStateEvaluator2;
import mage.player.ai.util.CombatInfo;
import mage.player.ai.util.CombatUtil;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.util.CardUtil;
import mage.util.RandomUtil;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;

public class ComputerPlayer6
extends ComputerPlayer {
    private static final Logger logger = Logger.getLogger(ComputerPlayer6.class);
    private static final int MAX_SIMULATED_NODES_PER_CALC = 5000;
    private static final int MAX_SIMULATED_NODES_PER_ERROR = 5100;
    private static final ExecutorService threadPoolSimulations = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new XmageThreadFactory("AI-SIM-MAD"));
    protected int maxDepth;
    protected int maxNodes;
    protected int maxThinkTimeSecs;
    protected LinkedList<Ability> actions = new LinkedList();
    protected List<UUID> targets = new ArrayList<UUID>();
    protected List<String> choices = new ArrayList<String>();
    protected Combat combat;
    protected int currentScore;
    protected SimulationNode2 root;
    List<Permanent> attackersList = new ArrayList<Permanent>();
    List<Permanent> attackersToCheck = new ArrayList<Permanent>();
    protected Set<String> actionCache;
    private static final List<TreeOptimizer> optimizers = new ArrayList<TreeOptimizer>();
    protected int lastLoggedTurn = 0;
    protected static final String BLANKS = "...............................................";

    public ComputerPlayer6(String name, RangeOfInfluence range, int skill) {
        super(name, range);
        this.maxDepth = skill < 4 ? 4 : skill;
        this.maxThinkTimeSecs = skill * 3;
        this.maxNodes = 5000;
        this.actionCache = new HashSet<String>();
    }

    public ComputerPlayer6(ComputerPlayer6 player) {
        super((ComputerPlayer)player);
        this.maxDepth = player.maxDepth;
        this.currentScore = player.currentScore;
        if (player.combat != null) {
            this.combat = player.combat.copy();
        }
        this.actions.addAll(player.actions);
        this.targets.addAll(player.targets);
        this.choices.addAll(player.choices);
        this.actionCache = player.actionCache;
    }

    public void setMaxThinkTimeSecs(int maxThinkTimeSecs) {
        this.maxThinkTimeSecs = maxThinkTimeSecs;
    }

    public ComputerPlayer6 copy() {
        return new ComputerPlayer6(this);
    }

    protected void printBattlefieldScore(Game game, String info) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"");
            logger.info((Object)("=================== " + info + ", turn " + game.getTurnNum() + ", " + game.getPlayer(game.getPriorityPlayerId()).getName() + " ==================="));
            logger.info((Object)("[Stack]: " + game.getStack()));
            this.printBattlefieldScore(game, this.playerId);
            for (UUID opponentId : game.getOpponents(this.playerId)) {
                this.printBattlefieldScore(game, opponentId);
            }
        }
    }

    protected void printBattlefieldScore(Game game, UUID playerId) {
        Player player = game.getPlayer(playerId);
        GameStateEvaluator2.PlayerEvaluateScore score = GameStateEvaluator2.evaluate((UUID)playerId, (Game)game);
        logger.info((Object)("[" + game.getPlayer(playerId).getName() + "]" + ", life = " + player.getLife() + ", score = " + score.getTotalScore() + " (" + score.getPlayerInfoFull() + ")"));
        String cardsInfo = player.getHand().getCards(game).stream().map(card -> card.getName() + ":" + 5).collect(Collectors.joining("; "));
        StringBuilder sb = new StringBuilder("-> Hand: [").append(cardsInfo).append("]");
        logger.info((Object)sb.toString());
        sb.setLength(0);
        String ownPermanentsInfo = game.getBattlefield().getAllPermanents().stream().filter(p -> p.isOwnedBy(player.getId())).map(p -> p.getName() + (p.isTapped() ? ",tapped" : "") + (p.isAttacking() ? ",attacking" : "") + (p.getBlocking() > 0 ? ",blocking" : "") + ":" + GameStateEvaluator2.evaluatePermanent((Permanent)p, (Game)game, (boolean)true)).collect(Collectors.joining("; "));
        sb.append("-> Permanents: [").append(ownPermanentsInfo).append("]");
        logger.info((Object)sb.toString());
    }

    protected void act(Game game) {
        if (this.actions == null || this.actions.isEmpty()) {
            this.pass(game);
        } else {
            boolean usedStack = false;
            while (this.actions.peek() != null) {
                Ability ability = this.actions.poll();
                logger.info((Object)String.format("===> SELECTED ACTION for %s: %s", this.getName(), this.getAbilityAndSourceInfo(game, ability, true)));
                if (!ability.getTargets().isEmpty()) {
                    for (Target target : ability.getTargets()) {
                        for (UUID id : target.getTargets()) {
                            target.updateTarget(id, game);
                            if (target.isNotTarget()) continue;
                            game.addSimultaneousEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.TARGETED, (UUID)id, (Ability)ability, (UUID)ability.getControllerId()));
                        }
                    }
                }
                this.activateAbility((ActivatedAbility)ability, game);
                if (!ability.isUsesStack()) continue;
                usedStack = true;
            }
            if (usedStack) {
                this.pass(game);
            }
        }
    }

    protected int addActions(SimulationNode2 node, int depth, int alpha, int beta) {
        int val;
        boolean stepFinished = false;
        if (logger.isTraceEnabled() && node != null && node.getAbilities() != null && !node.getAbilities().toString().equals("[Pass]")) {
            logger.trace((Object)("Add Action [" + depth + "] " + node.getAbilities().toString() + "  a: " + alpha + " b: " + beta));
        }
        Game game = node.getGame();
        if (Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"AI game sim interrupted by timeout");
            return GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
        }
        if (SimulationNode2.nodeCount > 5100) {
            throw new IllegalStateException("AI ERROR: too much nodes (possible actions)");
        }
        if (depth <= 0 || SimulationNode2.nodeCount > this.maxNodes || game.checkIfGameIsOver()) {
            val = GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("Add Actions -- reached end state  <").append(val).append('>');
                SimulationNode2 logNode = node;
                do {
                    sb.append((CharSequence)new StringBuilder(" <- [" + logNode.getDepth() + ']' + (logNode.getAbilities() != null ? logNode.getAbilities().toString() : "[empty]")));
                } while ((logNode = logNode.getParent()).getParent() != null);
                logger.trace((Object)sb);
            }
        } else if (!node.getChildren().isEmpty()) {
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Add Action [").append(depth).append("] -- something added children ").append(node.getAbilities() != null ? node.getAbilities().toString() : "null").append(" added children: ").append(node.getChildren().size()).append(" (");
                for (SimulationNode2 logNode : node.getChildren()) {
                    sb.append(logNode.getAbilities() != null ? logNode.getAbilities().toString() : "null").append(", ");
                }
                sb.append(')');
                logger.debug((Object)sb);
            }
            val = this.minimaxAB(node, depth - 1, alpha, beta);
        } else {
            logger.trace((Object)("Add Action -- alpha: " + alpha + " beta: " + beta + " depth:" + depth + " step:" + game.getTurnStepType() + " for player:" + game.getPlayer(game.getActivePlayerId()).getName()));
            if (this.allPassed(game)) {
                if (!game.getStack().isEmpty()) {
                    this.resolve(node, depth, game);
                } else {
                    stepFinished = true;
                }
            }
            if (game.checkIfGameIsOver()) {
                val = GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
            } else if (stepFinished) {
                logger.debug((Object)"Step finished");
                int testScore = GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
                val = game.isActivePlayer(this.playerId) ? (testScore < this.currentScore ? testScore : GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore()) : GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
            } else if (!node.getChildren().isEmpty()) {
                if (logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Add Action [").append(depth).append("] -- trigger ").append(node.getAbilities() != null ? node.getAbilities().toString() : "null").append(" added children: ").append(node.getChildren().size()).append(" (");
                    for (SimulationNode2 logNode : node.getChildren()) {
                        sb.append(logNode.getAbilities() != null ? logNode.getAbilities().toString() : "null").append(", ");
                    }
                    sb.append(')');
                    logger.debug((Object)sb);
                }
                val = this.minimaxAB(node, depth - 1, alpha, beta);
            } else {
                val = this.simulatePriority(node, game, depth, alpha, beta);
            }
        }
        node.setScore(val);
        logger.trace((Object)("returning -- score: " + val + " depth:" + depth + " step:" + game.getTurnStepType() + " for player:" + game.getPlayer(node.getPlayerId()).getName()));
        return val;
    }

    protected boolean getNextAction(Game game) {
        if (this.root != null && !this.root.children.isEmpty()) {
            SimulationNode2 test = this.root;
            this.root = this.root.children.get(0);
            while (!this.root.children.isEmpty() && !this.root.playerId.equals(this.playerId)) {
                test = this.root;
                this.root = this.root.children.get(0);
            }
            logger.trace((Object)("Sim getNextAction -- game value:" + game.getState().getValue(true) + " test value:" + test.gameValue));
            if (this.root.playerId.equals(this.playerId) && this.root.abilities != null && game.getState().getValue(true).hashCode() == test.gameValue) {
                logger.info((Object)"simulating -- continuing previous actions chain");
                this.actions = new LinkedList<Ability>(this.root.abilities);
                this.combat = this.root.combat;
                return true;
            }
            if (this.root.abilities == null || this.root.abilities.isEmpty()) {
                logger.info((Object)"simulating -- need re-calculation (no more actions)");
            } else if (game.getState().getValue(true).hashCode() != test.gameValue) {
                logger.info((Object)"simulating -- need re-calculation (game state changed between actions)");
            } else if (!this.root.playerId.equals(this.playerId)) {
                logger.info((Object)"simulating -- need re-calculation (active controller changed)");
            } else {
                logger.info((Object)"simulating -- need re-calculation (unknown reason)");
            }
            return false;
        }
        return false;
    }

    protected int minimaxAB(SimulationNode2 node, int depth, int alpha, int beta) {
        logger.trace((Object)("Sim minimaxAB [" + depth + "] -- a: " + alpha + " b: " + beta + " <" + (node != null ? Integer.valueOf(node.getScore()) : "null") + '>'));
        UUID currentPlayerId = (UUID)node.getGame().getPlayerList().get();
        SimulationNode2 bestChild = null;
        for (SimulationNode2 child : node.getChildren()) {
            Combat _combat = child.getCombat();
            if (alpha >= beta) break;
            if (SimulationNode2.nodeCount > 5100) {
                throw new IllegalStateException("AI ERROR: too much nodes (possible actions)");
            }
            if (SimulationNode2.nodeCount > this.maxNodes) break;
            int val = this.addActions(child, depth - 1, alpha, beta);
            if (!currentPlayerId.equals(this.playerId)) {
                if (val < beta) {
                    beta = val;
                    bestChild = child;
                    if (node.getCombat() == null) {
                        node.setCombat(_combat);
                        bestChild.setCombat(_combat);
                    }
                }
                if (val != -100000000) continue;
                logger.debug((Object)"lose - break");
                break;
            }
            if (val > alpha) {
                alpha = val;
                bestChild = child;
                if (node.getCombat() == null) {
                    node.setCombat(_combat);
                    bestChild.setCombat(_combat);
                }
            }
            if (val != 100000000) continue;
            logger.debug((Object)"win - break");
            break;
        }
        node.children.clear();
        if (bestChild != null) {
            node.children.add(bestChild);
        }
        if (!currentPlayerId.equals(this.playerId)) {
            return beta;
        }
        return alpha;
    }

    protected SearchEffect getSearchEffect(StackAbility ability) {
        for (Effect effect : ability.getEffects()) {
            if (!(effect instanceof SearchEffect)) continue;
            return (SearchEffect)effect;
        }
        return null;
    }

    protected void resolve(SimulationNode2 node, int depth, Game game) {
        TargetCard target;
        SearchEffect effect;
        StackObject stackObject = game.getStack().getFirstOrNull();
        if (stackObject == null) {
            throw new IllegalStateException("Catch empty stack on resolve (something wrong with sim code)");
        }
        if (stackObject instanceof StackAbility && (effect = this.getSearchEffect((StackAbility)stackObject)) != null && stackObject.getControllerId().equals(this.playerId) && !(target = effect.getTarget()).isChoiceCompleted(this.getId(), (Ability)((StackAbility)stackObject), game, null)) {
            for (UUID targetId : target.possibleTargets(stackObject.getControllerId(), stackObject.getStackAbility(), game)) {
                Game sim = game.createSimulationForAI();
                StackAbility newAbility = (StackAbility)stackObject.copy();
                SearchEffect newEffect = this.getSearchEffect(newAbility);
                newEffect.getTarget().addTarget(targetId, (Ability)newAbility, sim);
                sim.getStack().push(sim, (StackObject)newAbility);
                SimulationNode2 newNode = new SimulationNode2(node, sim, depth, stackObject.getControllerId());
                node.children.add(newNode);
                newNode.getTargets().add(targetId);
                logger.trace((Object)("Sim search -- node#: " + SimulationNode2.getCount() + " for player: " + sim.getPlayer(stackObject.getControllerId()).getName()));
            }
            return;
        }
        stackObject.resolve(game);
        if (stackObject instanceof StackAbility) {
            game.getStack().remove(stackObject, game);
        }
        game.applyEffects();
        game.getPlayers().resetPassed();
        game.getPlayerList().setCurrent((Object)game.getActivePlayerId());
    }

    protected Integer addActionsTimed() {
        FutureTask<Integer> task = new FutureTask<Integer>(() -> this.addActions(this.root, this.maxDepth, Integer.MIN_VALUE, Integer.MAX_VALUE));
        threadPoolSimulations.execute(task);
        try {
            int maxSeconds = this.maxThinkTimeSecs;
            logger.debug((Object)("maxThink: " + maxSeconds + " seconds "));
            Integer res = task.get(maxSeconds, TimeUnit.SECONDS);
            if (res != null) {
                return res;
            }
        }
        catch (InterruptedException | TimeoutException e) {
            logger.warn((Object)"");
            logger.warn((Object)"AI player thinks too long (report it to github):");
            logger.warn((Object)(" - player: " + this.getName()));
            logger.warn((Object)(" - battlefield size: " + this.root.game.getBattlefield().getAllPermanents().size()));
            logger.warn((Object)(" - stack: " + this.root.game.getStack()));
            logger.warn((Object)(" - game: " + this.root.game));
            this.printFreezeNode(this.root);
            logger.warn((Object)"");
            task.cancel(true);
        }
        catch (ExecutionException e) {
            logger.error((Object)("AI player catch game error in simulation - " + this.getName() + " - " + this.root.game + ": " + e), (Throwable)e);
            task.cancel(true);
            if (this.isTestMode() && this.isFastFailInTestMode()) {
                throw new IllegalStateException("One of the simulated games raise the error: " + e, e);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("AI simulation catch unknown error: " + e), e);
            task.cancel(true);
        }
        return 0;
    }

    private void printFreezeNode(SimulationNode2 root) {
        ArrayList<String> chain = new ArrayList<String>();
        SimulationNode2 node = root;
        while (node != null) {
            if (node.abilities != null && !node.abilities.isEmpty()) {
                Ability ability = node.abilities.get(0);
                String sourceInfo = CardUtil.getSourceIdName((Game)node.game, (Ability)ability);
                chain.add(String.format("%s: %s", sourceInfo.isEmpty() ? "unknown" : sourceInfo, ability));
            }
            node = node.children == null || node.children.isEmpty() ? null : node.children.get(0);
        }
        logger.warn((Object)"Possible freeze chain:");
        if (root != null && chain.isEmpty()) {
            logger.warn((Object)" - unknown use case (too many possible targets?)");
        }
        chain.forEach(s -> logger.warn((Object)(" - " + s)));
    }

    protected int simulatePriority(SimulationNode2 node, Game game, int depth, int alpha, int beta) {
        if (Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"AI game sim interrupted by timeout");
            return GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
        }
        node.setGameValue(game.getState().getValue(true).hashCode());
        SimulatedPlayer2 currentPlayer = (SimulatedPlayer2)game.getPlayer((UUID)game.getPlayerList().get());
        SimulationNode2 bestNode = null;
        List<Ability> allActions = currentPlayer.simulatePriority(game);
        this.optimize(game, allActions);
        int startedScore = GameStateEvaluator2.evaluate((UUID)this.getId(), (Game)node.getGame()).getTotalScore();
        if (logger.isInfoEnabled() && !allActions.isEmpty() && depth == this.maxDepth) {
            logger.info((Object)String.format("POSSIBLE ACTION CHAINS for %s (%d, started score: %d)%s", this.getName(), allActions.size(), startedScore, this.actions.isEmpty() ? "" : ":"));
            for (int i = 0; i < allActions.size(); ++i) {
                Ability possibleAbility = allActions.get(i);
                logger.info((Object)String.format("-> #%d (%s)", i + 1, this.getAbilityAndSourceInfo(game, possibleAbility, true)));
            }
        }
        int actionNumber = 0;
        int bestValSubNodes = Integer.MIN_VALUE;
        for (Ability action : allActions) {
            ++actionNumber;
            if (Thread.currentThread().isInterrupted()) {
                logger.info((Object)("Sim Prio [" + depth + "] -- interrupted"));
                break;
            }
            Game sim = game.createSimulationForAI();
            if (action instanceof StaticAbility || !sim.getPlayer(currentPlayer.getId()).activateAbility((ActivatedAbility)action.copy(), sim)) continue;
            sim.applyEffects();
            if (this.checkForRepeatedAction(sim, node, action, currentPlayer.getId())) {
                logger.debug((Object)("Sim Prio [" + depth + "] -- repeated action: " + action));
                continue;
            }
            if (!sim.checkIfGameIsOver() && (action.isUsesStack() || action instanceof PassAbility)) {
                UUID nextPlayerId = (UUID)sim.getPlayerList().get();
                do {
                    sim.getPlayer(nextPlayerId).pass(game);
                } while (!Objects.equals(nextPlayerId = (UUID)sim.getPlayerList().getNext(), this.getId()));
            }
            SimulationNode2 newNode = new SimulationNode2(node, sim, action, depth, currentPlayer.getId());
            sim.checkStateAndTriggered();
            int finalScore = action instanceof PassAbility && sim.getStack().isEmpty() ? GameStateEvaluator2.evaluate((UUID)this.getId(), (Game)sim).getTotalScore() : this.addActions(newNode, depth - 1, alpha, beta);
            logger.debug((Object)("Sim Prio " + BLANKS.substring(0, 2 + (this.maxDepth - depth) * 3) + '[' + depth + "]#" + actionNumber + " <" + finalScore + "> - (" + action + ") "));
            if (logger.isInfoEnabled() && depth >= this.maxDepth) {
                ArrayList<SimulationNode2> fullChain = new ArrayList<SimulationNode2>();
                fullChain.add(newNode);
                SimulationNode2 finalNode = newNode;
                while (!finalNode.getChildren().isEmpty()) {
                    finalNode = finalNode.getChildren().get(0);
                    fullChain.add(finalNode);
                }
                logger.info((Object)String.format("Sim Prio [%d] #%d <total score diff %s (from %s to %s)>", depth, actionNumber, this.printDiffScore(finalScore - startedScore), this.printDiffScore(startedScore), this.printDiffScore(finalScore)));
                for (int chainIndex = 0; chainIndex < fullChain.size(); ++chainIndex) {
                    SimulationNode2 currentNode = (SimulationNode2)fullChain.get(chainIndex);
                    SimulationNode2 prevNode = chainIndex == 0 ? node : (SimulationNode2)fullChain.get(chainIndex - 1);
                    int currentScore = GameStateEvaluator2.evaluate((UUID)this.getId(), (Game)currentNode.getGame()).getTotalScore();
                    int prevScore = GameStateEvaluator2.evaluate((UUID)this.getId(), (Game)prevNode.getGame()).getTotalScore();
                    if (currentNode.getAbilities() != null) {
                        if (currentNode.getAbilities().size() != 1) {
                            throw new IllegalStateException("AI's simulated game must contains only one selected action, but found: " + currentNode.getAbilities());
                        }
                        if (!currentNode.getTargets().isEmpty() || !currentNode.getChoices().isEmpty()) {
                            throw new IllegalStateException("WTF, simulated abilities with targets/choices");
                        }
                        logger.info((Object)String.format("Sim Prio [%d] -> next action: [%d]<diff %s> (%s)", depth, currentNode.getDepth(), this.printDiffScore(currentScore - prevScore), this.getAbilityAndSourceInfo(currentNode.getGame(), currentNode.getAbilities().get(0), true)));
                        continue;
                    }
                    if (!currentNode.getTargets().isEmpty()) {
                        String targetsInfo = currentNode.getTargets().stream().map(id -> {
                            Player player = game.getPlayer(id);
                            if (player != null) {
                                return player.getName();
                            }
                            MageObject object = game.getObject(id);
                            if (object != null) {
                                return object.getIdName();
                            }
                            return "unknown";
                        }).collect(Collectors.joining(", "));
                        logger.info((Object)String.format("Sim Prio [%d] -> with possible choices: [%d]<diff %s> (%s)", depth, currentNode.getDepth(), this.printDiffScore(currentScore - prevScore), targetsInfo));
                        continue;
                    }
                    if (!currentNode.getChoices().isEmpty()) {
                        String choicesInfo = String.join((CharSequence)", ", currentNode.getChoices());
                        logger.info((Object)String.format("Sim Prio [%d] -> with possible choices (must not see that code): [%d]<diff %s> (%s)", depth, currentNode.getDepth(), this.printDiffScore(currentScore - prevScore), choicesInfo));
                        continue;
                    }
                    logger.info((Object)String.format("Sim Prio [%d] -> with do nothing: [%d]<diff %s>", depth, currentNode.getDepth(), this.printDiffScore(currentScore - prevScore)));
                }
            }
            if (currentPlayer.getId().equals(this.playerId)) {
                if (finalScore > bestValSubNodes) {
                    bestValSubNodes = finalScore;
                }
                if (depth == this.maxDepth && action instanceof PassAbility) {
                    finalScore -= 5;
                }
                if (finalScore > alpha || depth == this.maxDepth && finalScore == alpha && RandomUtil.nextBoolean()) {
                    alpha = finalScore;
                    bestNode = newNode;
                    bestNode.setScore(finalScore);
                    if (!newNode.getChildren().isEmpty()) {
                        bestNode.setCombat(newNode.getChildren().get(0).getCombat());
                    }
                    if (depth == this.maxDepth) {
                        logger.info((Object)("Sim Prio [" + depth + "] -* BEST actions chain so far: <final score " + bestNode.getScore() + ">"));
                        node.children.clear();
                        node.children.add(bestNode);
                        node.setScore(bestNode.getScore());
                    }
                }
                if (finalScore == 100000000) {
                    logger.debug((Object)"Sim Prio -- win - break");
                    break;
                }
            } else {
                if (finalScore < beta) {
                    beta = finalScore;
                    bestNode = newNode;
                    bestNode.setScore(finalScore);
                    if (!newNode.getChildren().isEmpty()) {
                        bestNode.setCombat(newNode.getChildren().get(0).getCombat());
                    }
                }
                if (finalScore == -100000000) {
                    logger.debug((Object)"Sim Prio -- lose - break");
                    break;
                }
            }
            if (alpha >= beta) break;
            if (SimulationNode2.nodeCount > 5100) {
                throw new IllegalStateException("AI ERROR: too many nodes (possible actions)");
            }
            if (SimulationNode2.nodeCount <= this.maxNodes) continue;
            logger.debug((Object)"Sim Prio -- reached end-state");
            break;
        }
        if (depth == this.maxDepth) {
            logger.info((Object)("Sim Prio [" + depth + "] ## Ended due max actions chain depth limit (" + this.maxDepth + ") -- Nodes calculated: " + SimulationNode2.nodeCount));
        }
        if (bestNode != null) {
            node.children.clear();
            node.children.add(bestNode);
            node.setScore(bestNode.getScore());
            if (logger.isTraceEnabled() && !bestNode.getAbilities().toString().equals("[Pass]")) {
                logger.trace((Object)("Sim Prio [" + depth + "] -- Set after (depth=" + depth + ")  <" + bestNode.getScore() + "> " + bestNode.getAbilities().toString()));
            }
        }
        if (currentPlayer.getId().equals(this.playerId)) {
            return bestValSubNodes;
        }
        return beta;
    }

    protected String getAbilityAndSourceInfo(Game game, Ability ability, boolean showTargets) {
        if (ability.isModal()) {
            // empty if block
        }
        MageObject sourceObject = ability.getSourceObject(game);
        String abilityInfo = (sourceObject == null ? "" : sourceObject.getIdName() + ": ") + CardUtil.substring((String)ability.toString(), (int)30, (String)"...");
        String targetsInfo = "";
        if (showTargets) {
            ArrayList allTargetsInfo = new ArrayList();
            ability.getAllSelectedTargets().forEach(target -> target.getTargets().forEach(selectedId -> {
                StackObject stackObject;
                MageObject object;
                String xInfo = "";
                if (target instanceof TargetAmount) {
                    xInfo = "x" + target.getTargetAmount(selectedId) + " ";
                }
                String targetInfo = null;
                Player player = game.getPlayer(selectedId);
                if (player != null) {
                    targetInfo = player.getName();
                }
                if (targetInfo == null && (object = game.getObject(selectedId)) != null) {
                    targetInfo = object.getIdName();
                }
                if (targetInfo == null && (stackObject = game.getState().getStack().getStackObject(selectedId)) != null) {
                    targetInfo = CardUtil.substring((String)stackObject.toString(), (int)20, (String)"...");
                }
                if (targetInfo == null) {
                    targetInfo = "unknown";
                }
                allTargetsInfo.add(xInfo + targetInfo);
            }));
            targetsInfo = String.join((CharSequence)" + ", allTargetsInfo);
        }
        return abilityInfo + (targetsInfo.isEmpty() ? "" : " -> " + targetsInfo);
    }

    private String printDiffScore(int score) {
        if (score >= 0) {
            return "+" + score;
        }
        return "" + score;
    }

    protected void optimize(Game game, List<Ability> allActions) {
        for (TreeOptimizer optimizer : optimizers) {
            optimizer.optimize(game, allActions);
        }
        Collections.sort(allActions, new Comparator<Ability>(){

            @Override
            public int compare(Ability ability1, Ability ability2) {
                boolean cast2;
                boolean play2;
                boolean pass2;
                String rule1 = ability1.toString();
                String rule2 = ability2.toString();
                boolean pass1 = rule1.startsWith("Pass");
                if (pass1 != (pass2 = rule2.startsWith("Pass"))) {
                    if (pass1) {
                        return 1;
                    }
                    return -1;
                }
                boolean play1 = rule1.startsWith("Play");
                if (play1 != (play2 = rule2.startsWith("Play"))) {
                    if (play1) {
                        return -1;
                    }
                    return 1;
                }
                boolean cast1 = rule1.startsWith("Cast");
                if (cast1 != (cast2 = rule2.startsWith("Cast"))) {
                    if (cast1) {
                        return -1;
                    }
                    return 1;
                }
                return ability1.getRule().compareTo(ability2.getRule());
            }
        });
    }

    protected boolean allPassed(Game game) {
        for (Player player : game.getPlayers().values()) {
            if (player.isPassed() || player.hasLost() || player.hasLeft()) continue;
            return false;
        }
        return true;
    }

    public boolean choose(Outcome outcome, Choice choice, Game game) {
        if (this.choices.isEmpty()) {
            return super.choose(outcome, choice, game);
        }
        if (!choice.isChosen() && !choice.setChoiceByAnswers(this.choices, true)) {
            choice.setRandomChoice();
        }
        return true;
    }

    public boolean chooseTarget(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (this.targets.isEmpty()) {
            return super.chooseTarget(outcome, cards, target, source, game);
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) {
            for (UUID targetId : this.targets) {
                target.addTarget(targetId, source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) continue;
                this.targets.clear();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean choose(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (this.targets.isEmpty()) {
            return super.choose(outcome, cards, target, source, game);
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) {
            for (UUID targetId : this.targets) {
                target.add(targetId, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, cards)) continue;
                this.targets.clear();
                return true;
            }
            return false;
        }
        return true;
    }

    private void declareBlockers(Game game, UUID activePlayerId) {
        game.fireEvent(new GameEvent(GameEvent.EventType.DECLARE_BLOCKERS_STEP_PRE, null, null, activePlayerId));
        if (!game.replaceEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.DECLARING_BLOCKERS, (UUID)activePlayerId, (UUID)activePlayerId))) {
            List<Permanent> attackers = this.getAttackers(game);
            if (attackers == null) {
                return;
            }
            List<Permanent> possibleBlockers = super.getAvailableBlockers(game);
            if ((possibleBlockers = this.filterOutNonblocking(game, attackers, possibleBlockers)).isEmpty()) {
                return;
            }
            if ((attackers = this.filterOutUnblockable(game, attackers, possibleBlockers)).isEmpty()) {
                return;
            }
            CombatUtil.sortByPower(attackers, false);
            CombatInfo combatInfo = CombatUtil.blockWithGoodTrade2(game, attackers, possibleBlockers);
            Player player = game.getPlayer(this.playerId);
            boolean blocked = false;
            for (Map.Entry<Permanent, List<Permanent>> entry : combatInfo.getCombat().entrySet()) {
                UUID attackerId = entry.getKey().getId();
                List<Permanent> blockers = entry.getValue();
                if (blockers == null) continue;
                for (Permanent blocker : blockers) {
                    player.declareBlocker(player.getId(), blocker.getId(), attackerId, game);
                    blocked = true;
                }
            }
            if (blocked) {
                game.getPlayers().resetPassed();
            }
        }
    }

    private List<Permanent> filterOutNonblocking(Game game, List<Permanent> attackers, List<Permanent> blockers) {
        ArrayList<Permanent> blockersLeft = new ArrayList<Permanent>();
        block0: for (Permanent blocker : blockers) {
            for (Permanent attacker : attackers) {
                if (!blocker.canBlock(attacker.getId(), game)) continue;
                blockersLeft.add(blocker);
                continue block0;
            }
        }
        return blockersLeft;
    }

    private List<Permanent> filterOutUnblockable(Game game, List<Permanent> attackers, List<Permanent> blockers) {
        ArrayList<Permanent> attackersLeft = new ArrayList<Permanent>();
        for (Permanent attacker : attackers) {
            if (!CombatUtil.canBeBlocked(game, attacker, blockers)) continue;
            attackersLeft.add(attacker);
        }
        return attackersLeft;
    }

    private List<Permanent> getAttackers(Game game) {
        Set attackersUUID = game.getCombat().getAttackers();
        if (attackersUUID.isEmpty()) {
            return null;
        }
        ArrayList<Permanent> attackers = new ArrayList<Permanent>();
        for (UUID attackerId : attackersUUID) {
            Permanent permanent = game.getPermanent(attackerId);
            attackers.add(permanent);
        }
        return attackers;
    }

    private void declareAttackers(Game game, UUID activePlayerId) {
        this.attackersToCheck.clear();
        this.attackersList.clear();
        game.fireEvent(new GameEvent(GameEvent.EventType.DECLARE_ATTACKERS_STEP_PRE, null, null, activePlayerId));
        if (!game.replaceEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.DECLARING_ATTACKERS, (UUID)activePlayerId, (UUID)activePlayerId))) {
            List possibleBlockers;
            Player defender;
            Player attackingPlayer = game.getPlayer(activePlayerId);
            for (UUID defenderId : game.getOpponents(this.playerId, true)) {
                List<Permanent> killers;
                defender = game.getPlayer(defenderId);
                if (!defender.isInGame()) continue;
                this.attackersList = super.getAvailableAttackers(defenderId, game);
                if (this.attackersList.isEmpty() || (killers = CombatUtil.canKillOpponent(game, this.attackersList, possibleBlockers = defender.getAvailableBlockers(game), defender)).isEmpty()) continue;
                for (Permanent attacker : killers) {
                    attackingPlayer.declareAttacker(attacker.getId(), defenderId, game, false);
                }
                return;
            }
            for (UUID defenderId : game.getOpponents(this.playerId, true)) {
                defender = game.getPlayer(defenderId);
                if (!defender.isInGame()) continue;
                this.attackersList = super.getAvailableAttackers(defenderId, game);
                if (this.attackersList.isEmpty()) continue;
                possibleBlockers = defender.getAvailableBlockers(game);
                CombatEvaluator eval = new CombatEvaluator();
                for (Permanent attacker : this.attackersList) {
                    boolean safeToAttack = true;
                    int attackerValue = eval.evaluate(attacker, game);
                    for (Permanent blocker : possibleBlockers) {
                        int blockerValue = eval.evaluate(blocker, game);
                        if (attacker.getPower().getValue() <= blocker.getToughness().getValue() && attacker.getToughness().getValue() <= blocker.getPower().getValue()) {
                            safeToAttack = false;
                        }
                        if (attacker.getToughness().getValue() == blocker.getPower().getValue() && attacker.getPower().getValue() == blocker.getToughness().getValue() && (attackerValue > blockerValue || blocker.getAbilities().containsKey(FirstStrikeAbility.getInstance().getId()) || blocker.getAbilities().containsKey(DoubleStrikeAbility.getInstance().getId()) || blocker.getAbilities().contains((Ability)new ExaltedAbility()) || blocker.getAbilities().containsKey(DeathtouchAbility.getInstance().getId()) || blocker.getAbilities().containsKey(IndestructibleAbility.getInstance().getId()) || !attacker.getAbilities().containsKey(FirstStrikeAbility.getInstance().getId()) || !attacker.getAbilities().containsKey(DoubleStrikeAbility.getInstance().getId()) || !attacker.getAbilities().contains((Ability)new ExaltedAbility()))) {
                            safeToAttack = false;
                        }
                        if (attacker.getAbilities().containsKey(DeathtouchAbility.getInstance().getId()) || attacker.getAbilities().containsKey(IndestructibleAbility.getInstance().getId())) {
                            safeToAttack = true;
                        }
                        if (attacker.getAbilities().containsKey(FlyingAbility.getInstance().getId()) && !blocker.getAbilities().containsKey(FlyingAbility.getInstance().getId()) && !blocker.getAbilities().containsKey(ReachAbility.getInstance().getId())) {
                            safeToAttack = true;
                        }
                        if (safeToAttack) continue;
                        break;
                    }
                    if (attacker.getPower().getValue() == 0) {
                        safeToAttack = false;
                    }
                    if (!safeToAttack) continue;
                    this.attackersToCheck.add(attacker);
                }
                int totalPowerOfAttackers = 0;
                int usedPowerOfAttackers = 0;
                for (Permanent attacker : this.attackersToCheck) {
                    totalPowerOfAttackers += attacker.getPower().getValue();
                }
                ArrayList possiblePermanentDefenders = new ArrayList();
                game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_PLANESWALKER, activePlayerId, game).stream().filter(p -> p.canBeAttacked(null, defenderId, game)).forEach(possiblePermanentDefenders::add);
                game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_BATTLE, activePlayerId, game).stream().filter(p -> p.canBeAttacked(null, defenderId, game)).forEach(possiblePermanentDefenders::add);
                block6: for (Permanent permanentDefender : possiblePermanentDefenders) {
                    int currentCounters;
                    if (usedPowerOfAttackers >= totalPowerOfAttackers) break;
                    if (permanentDefender.isPlaneswalker(game)) {
                        currentCounters = permanentDefender.getCounters(game).getCount(CounterType.LOYALTY);
                    } else if (permanentDefender.isBattle(game)) {
                        currentCounters = permanentDefender.getCounters(game).getCount(CounterType.DEFENSE);
                    } else {
                        throw new IllegalStateException("AI: can't find counters for defending permanent " + permanentDefender.getName(), new Throwable());
                    }
                    for (Permanent attackingPermanent : this.attackersToCheck) {
                        if (attackingPermanent.isAttacking()) continue;
                        attackingPlayer.declareAttacker(attackingPermanent.getId(), permanentDefender.getId(), game, true);
                        usedPowerOfAttackers += attackingPermanent.getPower().getValue();
                        if ((currentCounters -= attackingPermanent.getPower().getValue()) > 0) continue;
                        continue block6;
                    }
                }
                for (Permanent attackingPermanent : this.attackersToCheck) {
                    if (attackingPermanent.isAttacking()) continue;
                    attackingPlayer.declareAttacker(attackingPermanent.getId(), defenderId, game, true);
                }
            }
        }
    }

    public void selectAttackers(Game game, UUID attackingPlayerId) {
        logger.debug((Object)"selectAttackers");
        this.declareAttackers(game, this.playerId);
    }

    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        logger.debug((Object)"selectBlockers");
        this.declareBlockers(game, this.playerId);
    }

    protected Game createSimulation(Game game) {
        Game sim = game.createSimulationForAI();
        for (Player oldPlayer : sim.getState().getPlayers().values()) {
            Player origPlayer = ((Player)game.getState().getPlayers().get((Object)oldPlayer.getId())).copy();
            SimulatedPlayer2 simPlayer = new SimulatedPlayer2(oldPlayer, oldPlayer.getId().equals(this.playerId));
            simPlayer.restore(origPlayer);
            sim.getState().getPlayers().put((Object)oldPlayer.getId(), (Object)simPlayer);
        }
        return sim;
    }

    private boolean checkForRepeatedAction(Game sim, SimulationNode2 node, Ability action, UUID playerId) {
        if (action instanceof PassAbility || action instanceof SpellAbility || action.isManaAbility()) {
            return false;
        }
        int newVal = GameStateEvaluator2.evaluate((UUID)playerId, (Game)sim).getTotalScore();
        for (SimulationNode2 test = node.getParent(); test != null; test = test.getParent()) {
            int oldVal;
            Game prevGame;
            if (!test.getPlayerId().equals(playerId) || test.getAbilities() == null || test.getAbilities().size() != 1 || !action.toString().equals(test.getAbilities().get(0).toString()) || test.getParent() == null || (prevGame = node.getGame()) == null || (oldVal = GameStateEvaluator2.evaluate((UUID)playerId, (Game)prevGame).getTotalScore()) < newVal) continue;
            return true;
        }
        return false;
    }

    public void cleanUpOnMatchEnd() {
        this.root = null;
        super.cleanUpOnMatchEnd();
    }

    static {
        optimizers.add(new WrongCodeUsageOptimizer());
        optimizers.add(new LevelUpOptimizer());
        optimizers.add(new EquipOptimizer());
        optimizers.add(new DiscardCardOptimizer());
        optimizers.add(new OutcomeOptimizer());
    }
}

