/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.RangeOfInfluence;
import mage.game.Game;
import mage.player.ai.ComputerPlayer6;
import mage.player.ai.SimulationNode2;
import mage.player.ai.score.GameStateEvaluator2;
import org.apache.log4j.Logger;

public class ComputerPlayer7
extends ComputerPlayer6 {
    private static final Logger logger = Logger.getLogger(ComputerPlayer7.class);
    private boolean allowBadMoves;

    public ComputerPlayer7(String name, RangeOfInfluence range, int skill) {
        super(name, range, skill);
    }

    public ComputerPlayer7(ComputerPlayer7 player) {
        super(player);
        this.allowBadMoves = player.allowBadMoves;
    }

    @Override
    public ComputerPlayer7 copy() {
        return new ComputerPlayer7(this);
    }

    public boolean priority(Game game) {
        game.resumeTimer(this.getTurnControlledBy());
        boolean result = this.priorityPlay(game);
        game.pauseTimer(this.getTurnControlledBy());
        return result;
    }

    private boolean priorityPlay(Game game) {
        game.getState().setPriorityPlayerId(this.playerId);
        game.firePriorityEvent(this.playerId);
        switch (game.getTurnStepType()) {
            case UPKEEP: 
            case DRAW: {
                this.pass(game);
                return false;
            }
            case PRECOMBAT_MAIN: {
                this.printBattlefieldScore(game, "Sim PRIORITY on MAIN 1");
                if (!this.actions.isEmpty()) {
                    throw new IllegalStateException("wtf");
                }
                this.calculateActions(game);
                this.act(game);
                return true;
            }
            case BEGIN_COMBAT: {
                this.pass(game);
                return false;
            }
            case DECLARE_ATTACKERS: {
                this.printBattlefieldScore(game, "Sim PRIORITY on DECLARE ATTACKERS");
                if (!this.actions.isEmpty()) {
                    throw new IllegalStateException("wtf");
                }
                this.calculateActions(game);
                this.act(game);
                return true;
            }
            case DECLARE_BLOCKERS: {
                this.printBattlefieldScore(game, "Sim PRIORITY on DECLARE BLOCKERS");
                if (!this.actions.isEmpty()) {
                    throw new IllegalStateException("wtf");
                }
                this.calculateActions(game);
                this.act(game);
                return true;
            }
            case FIRST_COMBAT_DAMAGE: 
            case COMBAT_DAMAGE: 
            case END_COMBAT: {
                this.pass(game);
                return false;
            }
            case POSTCOMBAT_MAIN: {
                this.printBattlefieldScore(game, "Sim PRIORITY on MAIN 2");
                if (!this.actions.isEmpty()) {
                    throw new IllegalStateException("wtf");
                }
                this.calculateActions(game);
                this.act(game);
                return true;
            }
            case END_TURN: 
            case CLEANUP: {
                this.actionCache.clear();
                this.pass(game);
                return false;
            }
        }
        return false;
    }

    protected void calculateActions(Game game) {
        if (!this.getNextAction(game)) {
            this.currentScore = GameStateEvaluator2.evaluate((UUID)this.playerId, (Game)game).getTotalScore();
            Game sim = this.createSimulation(game);
            SimulationNode2.resetCount();
            this.root = new SimulationNode2(null, sim, this.maxDepth, this.playerId);
            this.addActionsTimed();
            if (this.root != null && this.root.children != null && !this.root.children.isEmpty()) {
                logger.trace((Object)("After add actions timed: root.children.size = " + this.root.children.size()));
                this.root = this.root.children.get(0);
                boolean doThis = true;
                if (this.root.abilities.size() == 1) {
                    for (Ability ability : this.root.abilities) {
                        if (ability.getManaCosts().manaValue() != 0 || !ability.getCosts().isEmpty() || !this.actionCache.contains(ability.getRule() + '_' + ability.getSourceId())) continue;
                        doThis = false;
                    }
                }
                if (doThis) {
                    this.actions = new LinkedList<Ability>(this.root.abilities);
                    this.combat = this.root.combat;
                    for (Ability ability : this.actions) {
                        this.actionCache.add(ability.getRule() + '_' + ability.getSourceId());
                    }
                }
            } else {
                logger.info((Object)("AI player can't find next action: " + this.getName()));
            }
        } else {
            logger.debug((Object)"Next Action exists!");
        }
    }

    public void setAllowBadMoves(boolean allowBadMoves) {
        this.allowBadMoves = allowBadMoves;
    }
}

