/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.common.CanBeYourCommanderAbility;
import mage.abilities.keyword.CompanionAbility;
import mage.cards.Card;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidatorErrorType;
import mage.constants.CardType;
import mage.deck.Standard;
import mage.filter.FilterMana;
import mage.util.ManaUtil;

public class Brawl
extends Constructed {
    protected List<String> bannedCommander = new ArrayList<String>();

    public Brawl() {
        super("Brawl");
        this.setCodes.addAll(Standard.makeLegalSets());
        this.banned.add("Pithing Needle");
    }

    public int getSideboardMinSize() {
        return 1;
    }

    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        Object brawler = null;
        Card companion = null;
        FilterMana colorIdentity = new FilterMana();
        if (deck.getSideboard().size() == 1) {
            Iterator iterator = deck.getSideboard().iterator();
            while (iterator.hasNext()) {
                Card card;
                brawler = card = (Card)iterator.next();
            }
        } else if (deck.getSideboard().size() == 2) {
            Iterator iter = deck.getSideboard().iterator();
            Card card1 = (Card)iter.next();
            Card card2 = (Card)iter.next();
            if (card1.getAbilities().stream().anyMatch(CompanionAbility.class::isInstance)) {
                companion = card1;
                brawler = card2;
            } else if (card2.getAbilities().stream().anyMatch(CompanionAbility.class::isInstance)) {
                companion = card2;
                brawler = card1;
            } else {
                this.addError(DeckValidatorErrorType.PRIMARY, "Brawl", "Sideboard must contain only the brawler and up to 1 companion");
                valid = false;
            }
        } else {
            this.addError(DeckValidatorErrorType.PRIMARY, "Brawl", "Sideboard must contain only the brawler and up to 1 companion");
            valid = false;
        }
        if (brawler != null) {
            ManaUtil.collectColorIdentity((FilterMana)colorIdentity, (FilterMana)brawler.getColorIdentity());
            if (this.bannedCommander.contains(brawler.getName())) {
                this.addError(DeckValidatorErrorType.PRIMARY, brawler.getName(), "Brawler banned (" + brawler.getName() + ')', true);
                valid = false;
            }
            if (!(brawler.hasCardTypeForDeckbuilding(CardType.CREATURE) && brawler.isLegendary() || brawler.hasCardTypeForDeckbuilding(CardType.PLANESWALKER) || brawler.getAbilities().contains((Ability)CanBeYourCommanderAbility.getInstance()))) {
                this.addError(DeckValidatorErrorType.PRIMARY, brawler.getName(), "Brawler Invalid (" + brawler.getName() + ')', true);
                valid = false;
            }
        }
        if (companion != null && deck.getMaindeckCards().size() + deck.getSideboard().size() != this.getDeckMinSize() + 1) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain " + (this.getDeckMinSize() + 1) + " cards (companion doesn't count in deck size requirement): has " + (deck.getMaindeckCards().size() + deck.getSideboard().size()) + " cards");
            valid = false;
        } else if (companion == null && deck.getMaindeckCards().size() + deck.getSideboard().size() != this.getDeckMinSize()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain " + this.getDeckMinSize() + " cards: has " + (deck.getMaindeckCards().size() + deck.getSideboard().size()) + " cards");
            valid = false;
        }
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        valid = this.checkCounts(1, counts) && valid;
        for (Object bannedCard : this.banned) {
            if (!counts.containsKey(bannedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, (String)bannedCard, "Banned", true);
            valid = false;
        }
        HashSet<String> basicsInDeck = new HashSet<String>();
        if (colorIdentity.isColorless()) {
            for (Card card : deck.getCards()) {
                if (!ALL_BASIC_LAND_NAMES.contains(card.getName())) continue;
                basicsInDeck.add(card.getName());
            }
        }
        for (Card card : deck.getCards()) {
            if (ManaUtil.isColorIdentityCompatible((FilterMana)colorIdentity, (FilterMana)card.getColorIdentity()) || colorIdentity.isColorless() && basicsInDeck.size() == 1 && basicsInDeck.contains(card.getName())) continue;
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid color (need " + colorIdentity + ", but get " + card.getColorIdentity() + ")", true);
            valid = false;
        }
        for (Card card : deck.getSideboard()) {
            if (ManaUtil.isColorIdentityCompatible((FilterMana)colorIdentity, (FilterMana)card.getColorIdentity()) || colorIdentity.isColorless() && basicsInDeck.size() == 1 && basicsInDeck.contains(card.getName())) continue;
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid color (need " + colorIdentity + ", but get " + card.getColorIdentity() + ")", true);
            valid = false;
        }
        for (Card card : deck.getCards()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Not allowed Set: " + card.getExpansionSetCode(), true);
            valid = false;
        }
        for (Card card : deck.getSideboard()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Not allowed Set: " + card.getExpansionSetCode(), true);
            valid = false;
        }
        if (companion != null) {
            HashSet<Card> cards = new HashSet<Card>(deck.getCards());
            cards.add((Card)brawler);
            for (Ability ability : companion.getAbilities()) {
                if (!(ability instanceof CompanionAbility)) continue;
                CompanionAbility companionAbility = (CompanionAbility)ability;
                if (companionAbility.isLegal(cards, this.getDeckMinSize())) break;
                this.addError(DeckValidatorErrorType.PRIMARY, companion.getName(), String.format("Brawl companion illegal: %s", companionAbility.getLegalRule()), true);
                valid = false;
                break;
            }
        }
        return valid;
    }
}

