/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.Map;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.DeckValidatorErrorType;
import mage.deck.AbstractCommander;

public class Commander
extends AbstractCommander {
    public Commander() {
        this("Commander");
        this.banned.add("Ancestral Recall");
        this.banned.add("Balance");
        this.banned.add("Biorhythm");
        this.banned.add("Black Lotus");
        this.banned.add("Channel");
        this.banned.add("Dockside Extortionist");
        this.banned.add("Emrakul, the Aeons Torn");
        this.banned.add("Erayo, Soratami Ascendant");
        this.banned.add("Fastbond");
        this.banned.add("Flash");
        this.banned.add("Golos, Tireless Pilgrim");
        this.banned.add("Griselbrand");
        this.banned.add("Hullbreacher");
        this.banned.add("Iona, Shield of Emeria");
        this.banned.add("Jeweled Lotus");
        this.banned.add("Jihad");
        this.banned.add("Karakas");
        this.banned.add("Leovold, Emissary of Trest");
        this.banned.add("Library of Alexandria");
        this.banned.add("Limited Resources");
        this.banned.add("Lutri, the Spellchaser");
        this.banned.add("Mana Crypt");
        this.banned.add("Mox Emerald");
        this.banned.add("Mox Jet");
        this.banned.add("Mox Pearl");
        this.banned.add("Mox Ruby");
        this.banned.add("Mox Sapphire");
        this.banned.add("Nadu, Winged Wisdom");
        this.banned.add("Paradox Engine");
        this.banned.add("Primeval Titan");
        this.banned.add("Prophet of Kruphix");
        this.banned.add("Recurring Nightmare");
        this.banned.add("Rofellos, Llanowar Emissary");
        this.banned.add("Sundering Titan");
        this.banned.add("Sylvan Primordial");
        this.banned.add("Time Vault");
        this.banned.add("Time Walk");
        this.banned.add("Tinker");
        this.banned.add("Tolarian Academy");
        this.banned.add("Trade Secrets");
        this.banned.add("Upheaval");
        this.banned.add("Yawgmoth's Bargain");
    }

    protected Commander(String name) {
        super(name);
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (!set.getSetType().isEternalLegal()) continue;
            this.setCodes.add(set.getCode());
        }
    }

    @Override
    protected boolean checkBanned(Map<String, Integer> counts) {
        boolean valid = true;
        for (String bannedCard : this.banned) {
            if (!counts.containsKey(bannedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, bannedCard, "Banned", true);
            valid = false;
        }
        return valid;
    }
}

