/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;

public class HistoricalType2
extends Constructed {
    protected static final String[][] standards = new String[][]{{"DRK", "FEM", "4ED"}, {"FEM", "4ED", "ICE", "CHR", "HML", "ALL", "MIR"}, {"4ED", "CHR", "ALL", "MIR", "VIS"}, {"ICE", "HML", "ALL", "MIR", "VIS", "5ED", "WTH"}, {"MIR", "VIS", "5ED", "WTH", "TMP", "STH", "EXO"}, {"5ED", "TMP", "STH", "EXO", "USG", "ULG"}, {"TMP", "STH", "EXO", "USG", "ULG", "6ED", "UDS"}, {"USG", "ULG", "6ED", "UDS", "MMQ", "NEM", "PCY"}, {"6ED", "MMQ", "NEM", "PCY", "INV", "PLS"}, {"7ED", "MMQ", "NEM", "PCY", "INV", "PLS", "APC"}, {"7ED", "INV", "APC", "PLS", "ODY", "TOR", "JUD"}, {"7ED", "ODY", "TOR", "JUD", "ONS", "LGN", "SCG"}, {"8ED", "ODY", "TOR", "JUD", "ONS", "LGN", "SCG"}, {"8ED", "ONS", "LGN", "SCG", "MRD", "DST", "5DN"}, {"8ED", "MRD", "DST", "5DN", "CHK", "BOK", "SOK"}, {"9ED", "MRD", "DST", "5DN", "CHK", "BOK", "SOK"}, {"9ED", "CHK", "BOK", "SOK", "RAV", "GPT", "DIS", "CSP"}, {"9ED", "RAV", "GPT", "DIS", "CSP", "TSP", "TSB", "PLC", "FUT"}, {"10E", "RAV", "GPT", "DIS", "CSP", "TSP", "TSB", "PLC", "FUT"}, {"10E", "CSP", "TSP", "TSB", "PLC", "FUT", "LRW", "MOR", "SHM", "EVE"}, {"10E", "LRW", "MOR", "SHM", "EVE", "ALA", "CON", "ARB"}};

    public HistoricalType2() {
        super("Constructed - Historical Type 2", "Hist. Type 2");
        this.banned.add("Balance");
        this.banned.add("Earthcraft");
        this.banned.add("Memory Jar");
        this.banned.add("Mind Over Matter");
        this.banned.add("Mind Twist");
        this.banned.add("Skullclamp");
        this.banned.add("Time Spiral");
        this.banned.add("Tolarian Academy");
        this.banned.add("Yawgmoth's Bargain");
    }

    public boolean validate(Deck deck) {
        ArrayList leastInvalid = null;
        boolean valid = false;
        this.errorsList.clear();
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        if (counts.containsKey("Stoneforge Mystic") && counts.containsKey("Batterskull")) {
            return false;
        }
        for (String[] sets : standards) {
            this.errorsList.clear();
            this.setCodes = new ArrayList<String>(Arrays.asList(sets));
            if (super.validate(deck)) {
                valid = true;
                break;
            }
            if (leastInvalid == null) {
                leastInvalid = new ArrayList(this.getErrorsList());
                continue;
            }
            if (leastInvalid.size() <= this.getErrorsList().size()) continue;
            leastInvalid = new ArrayList(this.getErrorsList());
        }
        GregorianCalendar start = new GregorianCalendar(2006, 8, 1);
        GregorianCalendar end = new GregorianCalendar(2008, 8, 1);
        GregorianCalendar current = new GregorianCalendar();
        while (end.before(current) && !valid) {
            this.setCodes.clear();
            this.errorsList.clear();
            start.set(1, start.get(1) + 1);
            end.set(1, start.get(1) + 2);
            for (ExpansionSet set : Sets.getInstance().values()) {
                if (!set.getSetType().isStandardLegal() || !set.getReleaseDate().after(start.getTime()) || !set.getReleaseDate().before(end.getTime())) continue;
                this.setCodes.add(set.getCode());
            }
            if (super.validate(deck)) {
                this.errorsList.clear();
                valid = true;
                break;
            }
            if (leastInvalid == null) {
                leastInvalid = new ArrayList(this.getErrorsList());
                continue;
            }
            if (leastInvalid.size() <= this.getErrorsList().size()) continue;
            leastInvalid = new ArrayList(this.getErrorsList());
        }
        if (!valid) {
            this.errorsList = new ArrayList(leastInvalid);
        }
        return valid;
    }
}

