/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.HashMap;
import java.util.Map;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.DeckValidatorErrorType;
import mage.cards.decks.PennyDreadfulLegalityUtil;
import mage.deck.AbstractCommander;

public class PennyDreadfulCommander
extends AbstractCommander {
    private static final Map<String, Integer> pdAllowed = new HashMap<String, Integer>();

    public PennyDreadfulCommander() {
        super("Penny Dreadful Commander");
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (!set.getSetType().isEternalLegal()) continue;
            this.setCodes.add(set.getCode());
        }
    }

    @Override
    protected boolean checkBanned(Map<String, Integer> counts) {
        if (pdAllowed.isEmpty()) {
            pdAllowed.putAll(PennyDreadfulLegalityUtil.getLegalCardList());
        }
        boolean valid = true;
        for (String wantedCard : counts.keySet()) {
            if (pdAllowed.containsKey(wantedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, wantedCard, "Banned", true);
            valid = false;
        }
        return valid;
    }
}

