/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.Sets;
import mage.cards.SplitCard;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidatorErrorType;
import mage.constants.CardType;
import mage.filter.FilterMana;
import mage.game.GameTinyLeadersImpl;

public class TinyLeaders
extends Constructed {
    protected List<String> bannedCommander = new ArrayList<String>();

    public TinyLeaders() {
        super("Tiny Leaders");
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (!set.getSetType().isEternalLegal()) continue;
            this.setCodes.add(set.getCode());
        }
        this.banned.add("Ancestral Recall");
        this.banned.add("Balance");
        this.banned.add("Black Lotus");
        this.banned.add("Black Vise");
        this.banned.add("Channel");
        this.banned.add("Codie, Vociferous Codex");
        this.banned.add("Counterbalance");
        this.banned.add("Demonic Tutor");
        this.banned.add("Earthcraft");
        this.banned.add("Edric, Spymaster of Trest");
        this.banned.add("Fastbond");
        this.banned.add("Goblin Recruiter");
        this.banned.add("Grindstone");
        this.banned.add("Hermit Druid");
        this.banned.add("High Tide");
        this.banned.add("Imperial Seal");
        this.banned.add("Library of Alexandria");
        this.banned.add("Karakas");
        this.banned.add("Mana Crypt");
        this.banned.add("Mana Drain");
        this.banned.add("Mana Vault");
        this.banned.add("Metalworker");
        this.banned.add("Mind Twist");
        this.banned.add("Mishra's Workshop");
        this.banned.add("Mox Emerald");
        this.banned.add("Mox Jet");
        this.banned.add("Mox Pearl");
        this.banned.add("Mox Ruby");
        this.banned.add("Mox Sapphire");
        this.banned.add("Najeela, the Blade-Blossom");
        this.banned.add("Necropotence");
        this.banned.add("Sisay, Weatherlight Captain");
        this.banned.add("Skullclamp");
        this.banned.add("Sol Ring");
        this.banned.add("Strip Mine");
        this.banned.add("Survival of the Fittest");
        this.banned.add("Sword of Body and Mind");
        this.banned.add("Thassa's Oracle");
        this.banned.add("The Tabernacle at Pendrell Vale");
        this.banned.add("Time Vault");
        this.banned.add("Time Walk");
        this.banned.add("Timetwister");
        this.banned.add("Tolarian Academy");
        this.banned.add("Umezawa's Jitte");
        this.banned.add("Vampiric Tutor");
        this.banned.add("Wheel of Fortune");
        this.banned.add("Yawgmoth's Will");
        this.banned.add("Karn Liberated");
        this.bannedCommander.add("Erayo, Soratami Ascendant");
        this.bannedCommander.add("Rofellos, Llanowar Emissary");
        this.bannedCommander.add("Derevi, Empyrical Tactician");
    }

    public int getDeckMinSize() {
        return 49;
    }

    public int getSideboardMinSize() {
        return 0;
    }

    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        if (deck.getMaindeckCards().size() != this.getDeckMinSize()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain " + this.getDeckMinSize() + " cards: has " + deck.getMaindeckCards().size() + " cards");
            valid = false;
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put(deck.getName(), 1);
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        valid = this.checkCounts(1, counts) && valid;
        for (String bannedCard : this.banned) {
            if (!counts.containsKey(bannedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, bannedCard, "Banned", true);
            valid = false;
        }
        if (deck.getSideboard().size() <= 10) {
            Card commander = GameTinyLeadersImpl.getCommanderCard((String)deck.getName(), null);
            if (commander == null || commander.getManaValue() > 3) {
                if (commander == null) {
                    if (deck.getName() == null) {
                        this.addError(DeckValidatorErrorType.PRIMARY, "Leader", "You have to save your deck with the leader card name entered to the DECK NAME field of the DECK EDITOR (top left) so that XMage knows your leader.(You can use the \"Sultai\" for a UBG (3/3) default Commander or \"Glass\" for a colorless 3/3 default Commander.)");
                    } else {
                        this.addError(DeckValidatorErrorType.PRIMARY, "Leader", "Leader [" + deck.getName() + "] not found. You have to enter the name of the leader card into the DECK NAME field of the DECK EDITOR (top left). Check your spelling (use the \"Sultai\" for a UBG (3/3) default Commander or \"Glass\" for a colorless (3/3) default Commander)");
                    }
                }
                if (commander != null && commander.getManaValue() > 3) {
                    this.addError(DeckValidatorErrorType.PRIMARY, "Leader", "Commanders mana value is greater than 3");
                }
                return false;
            }
            if (commander.hasCardTypeForDeckbuilding(CardType.CREATURE) && commander.isLegendary() || commander.hasCardTypeForDeckbuilding(CardType.PLANESWALKER)) {
                if (!this.bannedCommander.contains(commander.getName())) {
                    FilterMana color = commander.getColorIdentity();
                    for (Card card : deck.getCards()) {
                        if (this.isCardFormatValid(card, commander, color)) continue;
                        valid = false;
                    }
                    for (Card card : deck.getSideboard()) {
                        if (this.isCardFormatValid(card, commander, color)) continue;
                        valid = false;
                    }
                } else {
                    this.addError(DeckValidatorErrorType.PRIMARY, commander.getName(), "Commander banned (" + commander.getName() + ')', true);
                    valid = false;
                }
            } else {
                this.addError(DeckValidatorErrorType.PRIMARY, commander.getName(), "Commander invalide (" + commander.getName() + ')', true);
                valid = false;
            }
        } else {
            this.addError(DeckValidatorErrorType.PRIMARY, "Commander", "Sideboard must contain only a maximum of 10 sideboard cards (the Tiny Leader name must be written to the deck name)");
            valid = false;
        }
        for (Card card : deck.getCards()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Not allowed Set " + card.getExpansionSetCode(), true);
            valid = false;
        }
        for (Card card : deck.getSideboard()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Not allowed Set " + card.getExpansionSetCode(), true);
            valid = false;
        }
        return valid;
    }

    private boolean isCardFormatValid(Card card, Card commander, FilterMana color) {
        if (!this.cardHasValideColor(color, card)) {
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid color (" + commander.getName() + ')', true);
            return false;
        }
        ArrayList<Integer> costs = new ArrayList<Integer>();
        if (card instanceof SplitCard) {
            costs.add(((SplitCard)card).getLeftHalfCard().getManaValue());
            costs.add(((SplitCard)card).getRightHalfCard().getManaValue());
        } else if (card instanceof ModalDoubleFacedCard) {
            costs.add(((ModalDoubleFacedCard)card).getLeftHalfCard().getManaValue());
            costs.add(((ModalDoubleFacedCard)card).getRightHalfCard().getManaValue());
        } else {
            costs.add(card.getManaValue());
        }
        return costs.stream().allMatch(cost -> {
            if (cost > 3) {
                this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid cost (" + cost + ')', true);
                return false;
            }
            return true;
        });
    }

    public boolean cardHasValideColor(FilterMana commander, Card card) {
        FilterMana cardColor = card.getColorIdentity();
        return !(cardColor.isBlack() && !commander.isBlack() || cardColor.isBlue() && !commander.isBlue() || cardColor.isGreen() && !commander.isGreen() || cardColor.isRed() && !commander.isRed() || cardColor.isWhite() && !commander.isWhite());
    }
}

