/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mage.collectors.DataCollectorServices;
import mage.game.Game;
import mage.game.Table;
import mage.game.tournament.Tournament;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.server.DisconnectReason;
import mage.server.User;
import mage.server.managers.ManagerFactory;
import mage.view.ChatMessage;
import org.apache.log4j.Logger;

public class ChatSession {
    private static final Logger logger = Logger.getLogger(ChatSession.class);
    private final ManagerFactory managerFactory;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private UUID roomId = null;
    private UUID tourneyId = null;
    private UUID tableId = null;
    private UUID gameId = null;
    private final ConcurrentMap<UUID, String> users = new ConcurrentHashMap<UUID, String>();
    private final Set<UUID> usersHistory = new HashSet<UUID>();
    private final UUID chatId;
    private final Date createTime;
    private final String info;

    public ChatSession(ManagerFactory managerFactory, String info) {
        this.managerFactory = managerFactory;
        this.chatId = UUID.randomUUID();
        this.createTime = new Date();
        this.info = info;
    }

    public ChatSession withRoom(UUID roomId) {
        this.roomId = roomId;
        return this;
    }

    public ChatSession withTourney(Tournament tournament) {
        this.tourneyId = tournament.getId();
        return this;
    }

    public ChatSession withTable(Table table) {
        this.tableId = table.getId();
        return this;
    }

    public ChatSession withGame(Game game) {
        this.gameId = game.getId();
        return this;
    }

    public void join(UUID userId) {
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> {
            if (!this.users.containsKey(userId)) {
                String userName = user.getName();
                Lock w = this.lock.writeLock();
                w.lock();
                try {
                    this.users.put(userId, userName);
                    this.usersHistory.add(userId);
                }
                finally {
                    w.unlock();
                }
                this.broadcast(null, userName + " has joined", ChatMessage.MessageColor.BLUE, true, null, ChatMessage.MessageType.STATUS, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectUser(UUID userId, DisconnectReason reason) {
        try {
            String userName = this.users.getOrDefault(userId, null);
            if (userName == null) {
                return;
            }
            Lock w = this.lock.writeLock();
            w.lock();
            try {
                this.users.remove(userId);
            }
            finally {
                w.unlock();
            }
            logger.debug((Object)(userName + " (" + (Object)((Object)reason) + ')' + " removed from chatId " + this.chatId));
            if (!reason.messageForUser.isEmpty()) {
                this.broadcast(null, userName + reason.messageForUser, ChatMessage.MessageColor.BLUE, true, null, ChatMessage.MessageType.STATUS, null);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("Chat: disconnecting user catch error: " + e), (Throwable)e);
        }
    }

    public void broadcastInfoToUser(User toUser, String message) {
        if (this.users.containsKey(toUser.getId())) {
            toUser.fireCallback(new ClientCallback(ClientCallbackMethod.CHATMESSAGE, this.chatId, (Object)new ChatMessage(null, message, new Date(), null, ChatMessage.MessageColor.BLUE, ChatMessage.MessageType.USER_INFO, null)));
        }
    }

    public boolean broadcastWhisperToUser(User fromUser, User toUser, String message) {
        if (this.users.containsKey(toUser.getId())) {
            toUser.fireCallback(new ClientCallback(ClientCallbackMethod.CHATMESSAGE, this.chatId, (Object)new ChatMessage(fromUser.getName(), message, new Date(), null, ChatMessage.MessageColor.YELLOW, ChatMessage.MessageType.WHISPER_FROM, ChatMessage.SoundToPlay.PlayerWhispered)));
            if (this.users.containsKey(fromUser.getId())) {
                fromUser.fireCallback(new ClientCallback(ClientCallbackMethod.CHATMESSAGE, this.chatId, (Object)new ChatMessage(toUser.getName(), message, new Date(), null, ChatMessage.MessageColor.YELLOW, ChatMessage.MessageType.WHISPER_TO, null)));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String userName, String message, ChatMessage.MessageColor color, boolean withTime, Game game, ChatMessage.MessageType messageType, ChatMessage.SoundToPlay soundToPlay) {
        if (!message.isEmpty()) {
            ChatMessage chatMessage = new ChatMessage(userName, message, withTime ? new Date() : null, game, color, messageType, soundToPlay);
            switch (messageType) {
                case USER_INFO: 
                case STATUS: 
                case TALK: {
                    if (this.roomId != null) {
                        DataCollectorServices.getInstance().onChatRoom(this.roomId, userName, message);
                        break;
                    }
                    if (this.tourneyId != null) {
                        DataCollectorServices.getInstance().onChatTourney(this.tourneyId, userName, message);
                        break;
                    }
                    if (this.tableId != null) {
                        DataCollectorServices.getInstance().onChatTable(this.tableId, userName, message);
                        break;
                    }
                    if (this.gameId == null) break;
                    DataCollectorServices.getInstance().onChatGame(this.gameId, userName, message);
                    break;
                }
                case GAME: {
                    break;
                }
                case WHISPER_FROM: 
                case WHISPER_TO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported message type " + messageType);
                }
            }
            HashSet<UUID> clientsToRemove = new HashSet<UUID>();
            ClientCallback clientCallback = new ClientCallback(ClientCallbackMethod.CHATMESSAGE, this.chatId, (Object)chatMessage);
            ArrayList chatUserIds = new ArrayList();
            Lock r = this.lock.readLock();
            r.lock();
            try {
                chatUserIds.addAll(this.users.keySet());
            }
            finally {
                r.unlock();
            }
            for (UUID userId : chatUserIds) {
                Optional<User> user = this.managerFactory.userManager().getUser(userId);
                if (user.isPresent()) {
                    user.get().fireCallback(clientCallback);
                    continue;
                }
                clientsToRemove.add(userId);
            }
            if (!clientsToRemove.isEmpty()) {
                Lock w = this.lock.writeLock();
                w.lock();
                try {
                    this.users.keySet().removeAll(clientsToRemove);
                }
                finally {
                    w.unlock();
                }
            }
        }
    }

    public UUID getChatId() {
        return this.chatId;
    }

    public boolean hasUser(UUID userId, boolean useHistory) {
        return useHistory ? this.usersHistory.contains(userId) : this.users.containsKey(userId);
    }

    public ConcurrentMap<UUID, String> getUsers() {
        return this.users;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getInfo() {
        return this.info;
    }
}

