/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import mage.server.ExtensionPackage;
import mage.server.util.PluginClassLoader;
import mage.util.StreamUtils;

public final class ExtensionPackageLoader {
    public static ExtensionPackage loadExtension(File directory) throws IOException {
        if (!directory.exists()) {
            throw new RuntimeException("File not found " + directory);
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException(directory + " is not a directory");
        }
        File entryPointFile = new File(directory, "entryPoint");
        if (!entryPointFile.exists() || !entryPointFile.isFile()) {
            throw new RuntimeException("Entry point definition not found.");
        }
        File packagesDirectory = new File(directory, "packages");
        if (!packagesDirectory.exists() || !packagesDirectory.isDirectory()) {
            throw new RuntimeException("Packages directory not found.");
        }
        Scanner entryPointReader = new Scanner(entryPointFile);
        String entryPoint = entryPointReader.nextLine().trim();
        entryPointReader.close();
        PluginClassLoader classLoader = null;
        try {
            classLoader = new PluginClassLoader();
            for (File f : packagesDirectory.listFiles()) {
                classLoader.addURL(f.toURI().toURL());
            }
            ExtensionPackage extensionPackage = (ExtensionPackage)Class.forName(entryPoint, false, classLoader).newInstance();
            return extensionPackage;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Entry point class not found!", classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Entry point not an instance of ExtensionPackage.", classCastException);
        }
        finally {
            StreamUtils.closeQuietly(classLoader);
        }
    }
}

