/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import mage.server.Main;
import mage.server.managers.ConfigSettings;
import mage.server.managers.MailClient;
import org.apache.log4j.Logger;

public class MailgunClientImpl
implements MailClient {
    private static final Logger logger = Logger.getLogger(Main.class);
    private final ConfigSettings config;

    public MailgunClientImpl(ConfigSettings config) {
        this.config = config;
    }

    @Override
    public boolean sendMessage(String email, String subject, String text) {
        boolean succeeded;
        if (email.isEmpty()) {
            logger.info((Object)"Email is not sent because the address is empty");
            return false;
        }
        Client client = Client.create();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter("api", this.config.getMailgunApiKey()));
        String domain = this.config.getMailgunDomain();
        WebResource webResource = client.resource("https://api.mailgun.net/v3/" + domain + "/messages");
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add("from", "XMage <postmaster@" + domain + '>');
        formData.add("to", email);
        formData.add("subject", subject);
        formData.add("text", text);
        ClientResponse response = (ClientResponse)webResource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)formData);
        boolean bl = succeeded = response.getStatus() == 200;
        if (!succeeded) {
            logger.error((Object)("Error sending message to " + email + ". Status code: " + response.getStatus()));
        }
        return succeeded;
    }
}

